/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkContext;
import org.apache.spark.internal.Logging;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class HdfsConfGenerator$
implements Logging {
    public static HdfsConfGenerator$ MODULE$;
    private final Method addFileMethod;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new HdfsConfGenerator$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Method addFileMethod() {
        return this.addFileMethod;
    }

    private void addFileOnSubmit(SparkContext sc, String path) {
        this.addFileMethod().invoke((Object)sc, path, BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false));
        Predef$.MODULE$.assert(sc.listFiles().nonEmpty());
        sc.conf().set("spark.app.initial.file.urls", sc.listFiles().mkString(","));
    }

    private boolean ignoreKey(String key) {
        return key.startsWith("yarn.") || key.startsWith("mapreduce.") || key.startsWith("hive.") || key.startsWith("io.") || key.startsWith("ipc.");
    }

    private boolean hasLibHdfsConf(SparkContext sc) {
        return sc.conf().getExecutorEnv().toMap(Predef$.MODULE$.$conforms()).contains((Object)"LIBHDFS3_CONF") || sc.listFiles().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("hdfs-client.xml"))) || package$.MODULE$.env().get((Object)"SPARK_CONF_DIR").orElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.env().get((Object)"SPARK_HOME").map((Function1 & Serializable & scala.Serializable)t -> new StringBuilder(4).append((String)t).append(File.separator).append("conf").toString())).exists((Function1 & Serializable & scala.Serializable)conf -> BoxesRunTime.boxToBoolean((boolean)HdfsConfGenerator$.$anonfun$hasLibHdfsConf$4(conf)));
    }

    public void addHdfsClientToSparkWorkDirectory(SparkContext sc) {
        if (sc.hadoopConfiguration().get("dfs.nameservices") == null) {
            return;
        }
        if (this.hasLibHdfsConf(sc)) {
            return;
        }
        File tmp = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        File hdfsClientConfFile = new File(tmp, "hdfs-client.xml");
        try (FileOutputStream output = new FileOutputStream(hdfsClientConfFile);){
            Configuration config = new Configuration(false);
            ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(sc.hadoopConfiguration().iterator()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)HdfsConfGenerator$.MODULE$.ignoreKey((String)x.getKey()))).foreach((Function1 & Serializable & scala.Serializable)x -> {
                config.set((String)x.getKey(), (String)x.getValue());
                return BoxedUnit.UNIT;
            });
            config.writeXml((OutputStream)output);
            String tmpPath = hdfsClientConfFile.getAbsolutePath();
            this.addFileOnSubmit(sc, tmpPath);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Added hdfs-client.xml for libhdfs, tmp path: ").append(tmpPath).append(".").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$hasLibHdfsConf$4(String conf) {
        return new File(new StringBuilder(15).append(conf).append(File.separator).append("hdfs-client.xml").toString()).isFile();
    }

    /*
     * WARNING - void declaration
     */
    private HdfsConfGenerator$() {
        void var1_1;
        MODULE$ = this;
        Logging.$init$((Logging)this);
        Method m = SparkContext.class.getDeclaredMethod("addFile", String.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
        m.setAccessible(true);
        this.addFileMethod = var1_1;
    }
}

