/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.rel;

import io.substrait.proto.JoinRel;
import io.substrait.proto.Rel;
import io.substrait.proto.RelCommon;
import java.io.Serializable;
import org.apache.gluten.substrait.expression.ExpressionNode;
import org.apache.gluten.substrait.extensions.AdvancedExtensionNode;
import org.apache.gluten.substrait.rel.RelNode;

public class JoinRelNode
implements RelNode,
Serializable {
    private final RelNode left;
    private final RelNode right;
    private final JoinRel.JoinType joinType;
    private final ExpressionNode expression;
    private final ExpressionNode postJoinFilter;
    private final AdvancedExtensionNode extensionNode;

    JoinRelNode(RelNode left, RelNode right, JoinRel.JoinType joinType, ExpressionNode expression, ExpressionNode postJoinFilter, AdvancedExtensionNode extensionNode) {
        this.left = left;
        this.right = right;
        this.joinType = joinType;
        this.expression = expression;
        this.postJoinFilter = postJoinFilter;
        this.extensionNode = extensionNode;
    }

    @Override
    public Rel toProtobuf() {
        RelCommon.Builder relCommonBuilder = RelCommon.newBuilder();
        relCommonBuilder.setDirect(RelCommon.Direct.newBuilder());
        JoinRel.Builder joinBuilder = JoinRel.newBuilder();
        joinBuilder.setType(this.joinType);
        if (this.left != null) {
            joinBuilder.setLeft(this.left.toProtobuf());
        }
        if (this.right != null) {
            joinBuilder.setRight(this.right.toProtobuf());
        }
        if (this.expression != null) {
            joinBuilder.setExpression(this.expression.toProtobuf());
        }
        if (this.postJoinFilter != null) {
            joinBuilder.setPostJoinFilter(this.postJoinFilter.toProtobuf());
        }
        if (this.extensionNode != null) {
            joinBuilder.setAdvancedExtension(this.extensionNode.toProtobuf());
        }
        return Rel.newBuilder().setJoin(joinBuilder.build()).build();
    }
}

