/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.v2;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.IUserGroupService;
import org.apache.kylin.rest.util.PagingUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/user_group"})
public class NUserGroupControllerV2
extends NBasicController {
    @Autowired
    @Qualifier(value="userGroupService")
    private IUserGroupService userGroupService;

    @ApiOperation(value="getUsersWithGroup", tags={"MID"})
    @GetMapping(value={"/usersWithGroup"}, produces={"application/vnd.apache.kylin-v2+json"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public EnvelopeResponse<Map<String, Object>> getUsersWithGroup(@RequestParam(value="pageOffset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="userGroupName", required=false, defaultValue="") String userGroupName) throws IOException {
        ArrayList<Pair> usersWithGroup = new ArrayList<Pair>();
        List groups = this.userGroupService.getAuthoritiesFilterByGroupName(userGroupName);
        List subList = PagingUtil.cutPage((List)groups, (int)pageOffset, (int)pageSize);
        for (String group : subList) {
            TreeSet<String> groupMembers = new TreeSet<String>();
            for (ManagedUser user : this.userGroupService.getGroupMembersByName(group)) {
                groupMembers.add(user.getUsername());
            }
            usersWithGroup.add(Pair.newPair((Object)group, groupMembers));
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("usersWithGroup", usersWithGroup);
        result.put("size", Integer.valueOf(groups.size()));
        return new EnvelopeResponse("000", result, "get users with group");
    }
}

