/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.v2;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.controller.NUserController;
import org.apache.kylin.rest.exception.UnauthorizedException;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.ManagedUserResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api"})
public class NUserControllerV2
extends NBasicController {
    private static final Logger logger = LoggerFactory.getLogger(NUserControllerV2.class);
    @Autowired
    private NUserController nUserController;

    @ApiOperation(value="listAllUsers", tags={"MID"})
    @GetMapping(value={"/kap/user/users"}, produces={"application/vnd.apache.kylin-v2+json"})
    @ResponseBody
    public EnvelopeResponse listAllUsers(@RequestParam(value="name", required=false) String nameSeg, @RequestParam(value="isCaseSensitive", required=false) boolean isCaseSensitive, @RequestParam(value="pageOffset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize) throws IOException {
        EnvelopeResponse<DataResult<List<ManagedUserResponse>>> dataResult = this.nUserController.listAllUsers(nameSeg, isCaseSensitive, pageOffset, pageSize);
        HashMap result = Maps.newHashMap();
        result.put("users", ((DataResult)dataResult.getData()).getValue());
        return new EnvelopeResponse(dataResult.getCode(), (Object)result, dataResult.getMsg());
    }

    @ApiOperation(value="authenticate", tags={"MID"})
    @PostMapping(value={"/user/authentication"}, produces={"application/vnd.apache.kylin-v2+json"})
    @ResponseBody
    public EnvelopeResponse<UserDetails> authenticate() {
        EnvelopeResponse<UserDetails> response = this.authenticatedUser();
        logger.debug("User login: {}", response.getData());
        return response;
    }

    @ApiOperation(value="authenticatedUser", tags={"MID"})
    @GetMapping(value={"/user/authentication"}, produces={"application/vnd.apache.kylin-v2+json"})
    @ResponseBody
    public EnvelopeResponse<UserDetails> authenticatedUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        UserDetails data = null;
        Message msg = MsgPicker.getMsg();
        if (authentication == null) {
            throw new UnauthorizedException((ErrorCodeProducer)ErrorCodeServer.USER_AUTH_INFO_NOTFOUND, new Object[0]);
        }
        if (authentication.getPrincipal() instanceof UserDetails) {
            data = (UserDetails)authentication.getPrincipal();
            return new EnvelopeResponse("000", (Object)data, "");
        }
        if (authentication.getDetails() instanceof UserDetails) {
            data = (UserDetails)authentication.getDetails();
            return new EnvelopeResponse("000", (Object)data, "");
        }
        throw new UnauthorizedException((ErrorCodeProducer)ErrorCodeServer.USER_AUTH_INFO_NOTFOUND, new Object[0]);
    }
}

