/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.shaded.influxdb.retrofit2.converter.moshi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.JsonAdapter;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.JsonQualifier;
import org.apache.kylin.shaded.influxdb.com.squareup.moshi.Moshi;
import org.apache.kylin.shaded.influxdb.okhttp3.RequestBody;
import org.apache.kylin.shaded.influxdb.okhttp3.ResponseBody;
import org.apache.kylin.shaded.influxdb.retrofit2.Converter;
import org.apache.kylin.shaded.influxdb.retrofit2.Retrofit;
import org.apache.kylin.shaded.influxdb.retrofit2.converter.moshi.MoshiRequestBodyConverter;
import org.apache.kylin.shaded.influxdb.retrofit2.converter.moshi.MoshiResponseBodyConverter;

public final class MoshiConverterFactory
extends Converter.Factory {
    private final Moshi moshi;
    private final boolean lenient;
    private final boolean failOnUnknown;
    private final boolean serializeNulls;

    public static MoshiConverterFactory create() {
        return MoshiConverterFactory.create(new Moshi.Builder().build());
    }

    public static MoshiConverterFactory create(Moshi moshi) {
        if (moshi == null) {
            throw new NullPointerException("moshi == null");
        }
        return new MoshiConverterFactory(moshi, false, false, false);
    }

    private MoshiConverterFactory(Moshi moshi, boolean lenient, boolean failOnUnknown, boolean serializeNulls) {
        this.moshi = moshi;
        this.lenient = lenient;
        this.failOnUnknown = failOnUnknown;
        this.serializeNulls = serializeNulls;
    }

    public MoshiConverterFactory asLenient() {
        return new MoshiConverterFactory(this.moshi, true, this.failOnUnknown, this.serializeNulls);
    }

    public MoshiConverterFactory failOnUnknown() {
        return new MoshiConverterFactory(this.moshi, this.lenient, true, this.serializeNulls);
    }

    public MoshiConverterFactory withNullSerialization() {
        return new MoshiConverterFactory(this.moshi, this.lenient, this.failOnUnknown, true);
    }

    @Override
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {
        JsonAdapter adapter = this.moshi.adapter(type, MoshiConverterFactory.jsonAnnotations(annotations));
        if (this.lenient) {
            adapter = adapter.lenient();
        }
        if (this.failOnUnknown) {
            adapter = adapter.failOnUnknown();
        }
        if (this.serializeNulls) {
            adapter = adapter.serializeNulls();
        }
        return new MoshiResponseBodyConverter(adapter);
    }

    @Override
    public Converter<?, RequestBody> requestBodyConverter(Type type, Annotation[] parameterAnnotations, Annotation[] methodAnnotations, Retrofit retrofit) {
        JsonAdapter adapter = this.moshi.adapter(type, MoshiConverterFactory.jsonAnnotations(parameterAnnotations));
        if (this.lenient) {
            adapter = adapter.lenient();
        }
        if (this.failOnUnknown) {
            adapter = adapter.failOnUnknown();
        }
        if (this.serializeNulls) {
            adapter = adapter.serializeNulls();
        }
        return new MoshiRequestBodyConverter(adapter);
    }

    private static Set<? extends Annotation> jsonAnnotations(Annotation[] annotations) {
        LinkedHashSet<Annotation> result = null;
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().isAnnotationPresent(JsonQualifier.class)) continue;
            if (result == null) {
                result = new LinkedHashSet<Annotation>();
            }
            result.add(annotation);
        }
        return result != null ? Collections.unmodifiableSet(result) : Collections.emptySet();
    }
}

