/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.RequestParameterBuilder;
import springfox.documentation.builders.ValidationResult;
import springfox.documentation.builders.Validator;

public class RequestParameterBuilderValidator
implements Validator<RequestParameterBuilder> {
    @Override
    public List<ValidationResult> validate(RequestParameterBuilder builder) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (StringUtils.isEmpty((Object)builder.name)) {
            results.add(new ValidationResult("RequestParameter", "name", "Parameter name is required"));
        }
        if (StringUtils.isEmpty((Object)((Object)builder.in))) {
            results.add(new ValidationResult("RequestParameter", "in", "Parameter in is required"));
        }
        if (builder.simpleParameterBuilder != null && builder.contentSpecificationBuilder != null) {
            results.add(new ValidationResult("RequestParameter", "in", String.format("Parameter %s can be either a simple parameter or content, but not both", builder.name)));
        }
        return results;
    }
}

