/*
 * Decompiled with CFR 0.152.
 */
package springfox.bean.validators.plugins.parameter;

import java.util.Optional;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.bean.validators.plugins.RangeAnnotations;
import springfox.bean.validators.plugins.Validators;
import springfox.documentation.common.Compatibility;
import springfox.documentation.schema.NumericElementFacet;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483148)
public class MinMaxAnnotationPlugin
implements ParameterBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(MinMaxAnnotationPlugin.class);

    @Override
    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    @Override
    public void apply(ParameterContext context) {
        Optional<Min> min = Validators.annotationFromParameter(context, Min.class);
        Optional<Max> max = Validators.annotationFromParameter(context, Max.class);
        if (min.isPresent() || max.isPresent()) {
            Compatibility<AllowableRangeValues, NumericElementFacet> values = RangeAnnotations.allowableRange(min, max);
            LOG.debug(String.format("Adding allowable Values: %s", values.getLegacy().map(AllowableRangeValues::toString).orElse("<none>")));
            context.parameterBuilder().allowableValues(values.getLegacy().orElse(null));
            LOG.debug(String.format("Adding numeric element facet : %s", values.getModern().map(NumericElementFacet::toString).orElse("<none>")));
            context.requestParameterBuilder().query(q -> q.numericFacet(n -> n.copyOf(values.getModern().orElse(null))));
        }
    }
}

