/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.plugin.core.config;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.ResolvableType;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.plugin.core.OrderAwarePluginRegistry;
import org.springframework.plugin.core.Plugin;
import org.springframework.plugin.core.config.EnablePluginRegistries;
import org.springframework.plugin.core.support.PluginRegistryFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PluginRegistriesBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar {
    private static final Logger LOG = LoggerFactory.getLogger(PluginRegistriesBeanDefinitionRegistrar.class);

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Class[] types;
        Map annotationAttributes = importingClassMetadata.getAnnotationAttributes(EnablePluginRegistries.class.getName());
        if (annotationAttributes == null) {
            LOG.info("No EnablePluginRegistries annotation found on type {}!", (Object)importingClassMetadata.getClassName());
            return;
        }
        for (Class type : types = (Class[])annotationAttributes.get("value")) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(PluginRegistryFactoryBean.class);
            builder.addPropertyValue("type", (Object)type);
            RootBeanDefinition beanDefinition = (RootBeanDefinition)builder.getBeanDefinition();
            beanDefinition.setTargetType(PluginRegistriesBeanDefinitionRegistrar.getTargetType(type));
            Qualifier annotation = type.getAnnotation(Qualifier.class);
            if (annotation != null) {
                AutowireCandidateQualifier qualifierMetadata = new AutowireCandidateQualifier(Qualifier.class);
                qualifierMetadata.setAttribute("value", (Object)annotation.value());
                beanDefinition.addQualifier(qualifierMetadata);
            }
            String beanName = annotation == null ? StringUtils.uncapitalize((String)(type.getSimpleName() + "Registry")) : annotation.value();
            registry.registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
        }
    }

    private static ResolvableType getTargetType(Class<?> pluginClass) {
        Assert.notNull(pluginClass, (String)"Plugin type must not be null!");
        ResolvableType delimiterType = ResolvableType.forClass(Plugin.class, pluginClass).getGeneric(new int[]{0});
        ResolvableType pluginType = ResolvableType.forClass(pluginClass);
        return ResolvableType.forClassWithGenerics(OrderAwarePluginRegistry.class, (ResolvableType[])new ResolvableType[]{pluginType, delimiterType});
    }
}

