/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class DescriptionResolver {
    private static final Pattern PATTERN = Pattern.compile("\\Q${\\E(.+?)(:(.*))?\\Q}\\E");
    private final Environment environment;
    private Map<String, String> cache;

    public DescriptionResolver(Environment environment) {
        this.environment = environment;
        this.cache = new HashMap<String, String>();
    }

    public String resolve(String expression) {
        if (StringUtils.isEmpty((Object)expression)) {
            return expression;
        }
        if (this.cache.containsKey(expression)) {
            return this.cache.get(expression);
        }
        if (!expression.startsWith("$")) {
            this.cache.put(expression, expression);
            return expression;
        }
        Matcher matcher = PATTERN.matcher(expression);
        if (matcher.find()) {
            String key = matcher.group(1);
            String defaultValue = matcher.group(3);
            String value = this.environment.getProperty(key);
            if (value != null) {
                this.cache.put(expression, value);
                return value;
            }
            if (defaultValue != null) {
                this.cache.put(expression, defaultValue);
                return defaultValue;
            }
        }
        this.cache.put(expression, expression);
        return expression;
    }
}

