/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.unix.freebsd;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.CentralProcessor;
import oshi.hardware.common.AbstractCentralProcessor;
import oshi.jna.platform.unix.CLibrary;
import oshi.jna.platform.unix.freebsd.Libc;
import oshi.util.ExecutingCommand;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.freebsd.BsdSysctlUtil;

public class FreeBsdCentralProcessor
extends AbstractCentralProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(FreeBsdCentralProcessor.class);
    private static final Pattern CPUMASK = Pattern.compile(".*<cpu\\s.*mask=\"(?:0x)?(\\p{XDigit}+)\".*>.*</cpu>.*");
    private static final Pattern CPUINFO = Pattern.compile("Origin=\"([^\"]*)\".*Id=(\\S+).*Family=(\\S+).*Model=(\\S+).*Stepping=(\\S+).*");
    private static final Pattern CPUINFO2 = Pattern.compile("Features=(\\S+)<.*");
    private static final long BOOTTIME;

    public FreeBsdCentralProcessor() {
        this.initVars();
        this.initTicks();
        LOG.debug("Initialized Processor");
    }

    private void initVars() {
        this.setName(BsdSysctlUtil.sysctl("hw.model", ""));
        long processorID = 0L;
        List<String> cpuInfo = FileUtil.readFile("/var/run/dmesg.boot");
        for (String line : cpuInfo) {
            Matcher m;
            if ((line = line.trim()).startsWith("CPU:") && this.getName().isEmpty()) {
                this.setName(line.replace("CPU:", "").trim());
                continue;
            }
            if (line.startsWith("Origin=")) {
                m = CPUINFO.matcher(line);
                if (!m.matches()) continue;
                this.setVendor(m.group(1));
                processorID |= Long.decode(m.group(2)).longValue();
                this.setFamily(Integer.decode(m.group(3)).toString());
                this.setModel(Integer.decode(m.group(4)).toString());
                this.setStepping(Integer.decode(m.group(5)).toString());
                continue;
            }
            if (!line.startsWith("Features=")) continue;
            m = CPUINFO2.matcher(line);
            if (!m.matches()) break;
            processorID |= Long.decode(m.group(1)) << 32;
            break;
        }
        this.setCpu64(ExecutingCommand.getFirstAnswer("uname -m").trim().contains("64"));
        this.setProcessorID(this.getProcessorID(processorID));
    }

    @Override
    protected void calculateProcessorCounts() {
        String[] topology = BsdSysctlUtil.sysctl("kern.sched.topology_spec", "").split("\\n|\\r");
        int physMask = 0;
        int virtMask = 0;
        int lastMask = 0;
        int physPackage = 0;
        for (String topo : topology) {
            if (topo.contains("<cpu")) {
                Matcher m = CPUMASK.matcher(topo);
                if (!m.matches()) continue;
                lastMask = Integer.parseInt(m.group(1), 16);
                physMask |= lastMask;
                virtMask |= lastMask;
                continue;
            }
            if (topo.contains("<flags>") && (topo.contains("HTT") || topo.contains("SMT") || topo.contains("THREAD"))) {
                physMask &= ~lastMask;
                continue;
            }
            if (!topo.contains("<group level=\"2\"")) continue;
            ++physPackage;
        }
        this.logicalProcessorCount = Integer.bitCount(virtMask);
        if (this.logicalProcessorCount < 1) {
            LOG.error("Couldn't find logical processor count. Assuming 1.");
            this.logicalProcessorCount = 1;
        }
        this.physicalProcessorCount = Integer.bitCount(physMask);
        if (this.physicalProcessorCount < 1) {
            LOG.error("Couldn't find physical processor count. Assuming 1.");
            this.physicalProcessorCount = 1;
        }
        this.physicalPackageCount = physPackage;
        if (this.physicalPackageCount < 1) {
            LOG.error("Couldn't find physical package count. Assuming 1.");
            this.physicalPackageCount = 1;
        }
    }

    @Override
    public synchronized long[] getSystemCpuLoadTicks() {
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        Libc.CpTime cpTime = new Libc.CpTime();
        BsdSysctlUtil.sysctl("kern.cp_time", cpTime);
        ticks[CentralProcessor.TickType.USER.getIndex()] = cpTime.cpu_ticks[0];
        ticks[CentralProcessor.TickType.NICE.getIndex()] = cpTime.cpu_ticks[1];
        ticks[CentralProcessor.TickType.SYSTEM.getIndex()] = cpTime.cpu_ticks[2];
        ticks[CentralProcessor.TickType.IRQ.getIndex()] = cpTime.cpu_ticks[3];
        ticks[CentralProcessor.TickType.IDLE.getIndex()] = cpTime.cpu_ticks[4];
        return ticks;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int retval = Libc.INSTANCE.getloadavg(average, nelem);
        if (retval < nelem) {
            for (int i = Math.max(retval, 0); i < average.length; ++i) {
                average[i] = -1.0;
            }
        }
        return average;
    }

    @Override
    public long[][] getProcessorCpuLoadTicks() {
        long[][] ticks = new long[this.logicalProcessorCount][CentralProcessor.TickType.values().length];
        String name = "kern.cp_times";
        long size = new Libc.CpTime().size();
        long arraySize = size * (long)this.logicalProcessorCount;
        Memory p = new Memory(arraySize);
        if (0 != Libc.INSTANCE.sysctlbyname(name, (Pointer)p, new IntByReference((int)arraySize), null, 0)) {
            LOG.error("Failed syctl call: {}, Error code: {}", (Object)name, (Object)Native.getLastError());
            return ticks;
        }
        for (int cpu = 0; cpu < this.logicalProcessorCount; ++cpu) {
            ticks[cpu][CentralProcessor.TickType.USER.getIndex()] = p.getLong(size * (long)cpu + (long)(0 * Libc.UINT64_SIZE));
            ticks[cpu][CentralProcessor.TickType.NICE.getIndex()] = p.getLong(size * (long)cpu + (long)(1 * Libc.UINT64_SIZE));
            ticks[cpu][CentralProcessor.TickType.SYSTEM.getIndex()] = p.getLong(size * (long)cpu + (long)(2 * Libc.UINT64_SIZE));
            ticks[cpu][CentralProcessor.TickType.IRQ.getIndex()] = p.getLong(size * (long)cpu + (long)(3 * Libc.UINT64_SIZE));
            ticks[cpu][CentralProcessor.TickType.IDLE.getIndex()] = p.getLong(size * (long)cpu + (long)(4 * Libc.UINT64_SIZE));
        }
        return ticks;
    }

    @Override
    public long getSystemUptime() {
        return System.currentTimeMillis() / 1000L - BOOTTIME;
    }

    private String getProcessorID(long processorID) {
        boolean procInfo = false;
        String marker = "Processor Information";
        for (String checkLine : ExecutingCommand.runNative("dmidecode -t system")) {
            if (!procInfo && checkLine.contains(marker)) {
                marker = "ID:";
                procInfo = true;
                continue;
            }
            if (!procInfo || !checkLine.contains(marker)) continue;
            return checkLine.split(marker)[1].trim();
        }
        return String.format("%016X", processorID);
    }

    @Override
    public long getContextSwitches() {
        String name = "vm.stats.sys.v_swtch";
        IntByReference size = new IntByReference(Libc.INT_SIZE);
        Memory p = new Memory((long)size.getValue());
        if (0 != Libc.INSTANCE.sysctlbyname(name, (Pointer)p, size, null, 0)) {
            return -1L;
        }
        return ParseUtil.unsignedIntToLong(p.getInt(0L));
    }

    @Override
    public long getInterrupts() {
        String name = "vm.stats.sys.v_intr";
        IntByReference size = new IntByReference(Libc.INT_SIZE);
        Memory p = new Memory((long)size.getValue());
        if (0 != Libc.INSTANCE.sysctlbyname(name, (Pointer)p, size, null, 0)) {
            return -1L;
        }
        return ParseUtil.unsignedIntToLong(p.getInt(0L));
    }

    static {
        CLibrary.Timeval tv = new CLibrary.Timeval();
        BOOTTIME = !BsdSysctlUtil.sysctl("kern.boottime", tv) || tv.tv_sec == 0L ? ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("sysctl -n kern.boottime").split(",")[0].replaceAll("\\D", ""), System.currentTimeMillis() / 1000L) : tv.tv_sec;
    }
}

