/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.planner;

import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kylin.engine.spark.planner.HLLCountCounter;
import org.apache.kylin.engine.spark.planner.TupleCountCounter;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.sql.Row;
import scala.Tuple2;

public class HLLCountFlatMapFunc
implements PairFlatMapFunction<Iterator<Row>, BitSet, byte[]> {
    private final int precision;
    private final Map<BitSet, List<Integer>> cuboidIndexMap;

    public HLLCountFlatMapFunc(int precision, Map<BitSet, List<Integer>> cuboidIndexMap) {
        this.precision = precision;
        this.cuboidIndexMap = cuboidIndexMap;
    }

    public Iterator<Tuple2<BitSet, byte[]>> call(Iterator<Row> rowIter) throws Exception {
        final HLLCountCounter hllCounter = new HLLCountCounter(this.precision, this.cuboidIndexMap);
        while (rowIter.hasNext()) {
            hllCounter.readRow(rowIter.next());
        }
        return new Iterator<Tuple2<BitSet, byte[]>>(){
            private final Iterator<TupleCountCounter> innerIter;
            {
                this.innerIter = hllCounter.counterIterator();
            }

            @Override
            public boolean hasNext() {
                return this.innerIter.hasNext();
            }

            @Override
            public Tuple2<BitSet, byte[]> next() {
                TupleCountCounter counter = this.innerIter.next();
                return new Tuple2((Object)counter.getCuboid(), (Object)counter.countBytes());
            }
        };
    }
}

