/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.merger;

import java.io.IOException;
import java.util.Set;
import lombok.Generated;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.ExecutableUtils;
import org.apache.kylin.engine.spark.job.SnapshotBuildFinishedEvent;
import org.apache.kylin.engine.spark.merger.MetadataMerger;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.execution.MergerInfo;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AfterSnapshotMerger
extends MetadataMerger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AfterSnapshotMerger.class);

    public AfterSnapshotMerger(KylinConfig config, String project) {
        super(config, project);
    }

    public void mergeRemoteMetaAfterSnapshot(String outputMetaUrl, String tableIdentity, String selectPartCol, boolean incrementBuild) {
        try (ResourceStore remoteStore = ExecutableUtils.getRemoteStore((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)outputMetaUrl);){
            String project = this.getProject();
            NTableMetadataManager remoteTblMgr = NTableMetadataManager.getInstance((KylinConfig)remoteStore.getConfig(), (String)project);
            TableDesc remoteTbDesc = remoteTblMgr.getTableDesc(tableIdentity);
            TableExtDesc remoteTblExtDesc = remoteTblMgr.getOrCreateTableExt(remoteTbDesc);
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            String baseDir = KapConfig.getInstanceFromEnv().getMetadataWorkingDirectory();
            if (selectPartCol != null && !incrementBuild) {
                remoteTbDesc.setLastSnapshotPath(remoteTbDesc.getTempSnapshotPath());
            }
            long snapshotSize = 0L;
            try {
                snapshotSize = HadoopUtil.getContentSummary((FileSystem)fs, (Path)new Path(baseDir + remoteTbDesc.getLastSnapshotPath())).getLength();
            }
            catch (IOException e) {
                log.warn("Fetch snapshot size for {} from {} failed", (Object)remoteTbDesc.getIdentity(), (Object)(baseDir + remoteTbDesc.getLastSnapshotPath()));
            }
            remoteTbDesc.setLastSnapshotSize(snapshotSize);
            EventBusFactory.getInstance().postSync((Object)new SnapshotBuildFinishedEvent(remoteTbDesc, selectPartCol, incrementBuild));
            this.mergeRemoteMetaAfterBuilding(remoteTbDesc, remoteTblExtDesc, tableIdentity, selectPartCol);
        }
    }

    private void mergeRemoteMetaAfterBuilding(TableDesc remoteTbDesc, TableExtDesc remoteTblExtDesc, String tableIdentity, String selectPartCol) {
        String project = this.getProject();
        NTableMetadataManager localTblMgr = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        TableDesc localTbDesc = localTblMgr.getTableDesc(tableIdentity);
        TableDesc copy = localTblMgr.copyForWrite(localTbDesc);
        TableExtDesc copyExt = localTblMgr.copyForWrite(localTblMgr.getOrCreateTableExt(localTbDesc));
        copy.setLastSnapshotPath(remoteTbDesc.getLastSnapshotPath());
        copy.setLastSnapshotSize(remoteTbDesc.getLastSnapshotSize());
        copy.setSnapshotLastModified(System.currentTimeMillis());
        copy.setSnapshotHasBroken(false);
        copy.setSnapshotTotalRows(remoteTbDesc.getSnapshotTotalRows());
        if (selectPartCol == null) {
            copyExt.setOriginalSize(remoteTblExtDesc.getOriginalSize());
            copy.setSnapshotPartitionCol(null);
            copy.resetSnapshotPartitions((Set)Sets.newHashSet());
        } else {
            copyExt.setOriginalSize(remoteTbDesc.getSnapshotPartitions().values().stream().mapToLong(i -> i).sum());
            copy.setSnapshotPartitionCol(selectPartCol);
            copy.setSnapshotPartitions(remoteTbDesc.getSnapshotPartitions());
            copy.setSnapshotPartitionsInfo(remoteTbDesc.getSnapshotPartitionsInfo());
        }
        copyExt.setTotalRows(remoteTblExtDesc.getTotalRows());
        localTblMgr.saveTableExt(copyExt);
        localTblMgr.updateTableDesc(copy);
    }

    @Override
    public <T> T merge(MergerInfo.TaskMergeInfo info) {
        this.mergeRemoteMetaAfterSnapshot(info.getOutputMetaUrl(), info.getTableIdentity(), info.getSelectPartCol(), info.isIncrementBuild());
        return null;
    }
}

