/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job.stage.optimize;

import io.delta.tables.DeltaTable;
import io.delta.tables.DeltaTable$;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.job.LayoutDataOptimizeJob;
import org.apache.kylin.engine.spark.job.SegmentExec;
import org.apache.kylin.engine.spark.job.stage.optimize.LayoutOptimizeExec;
import org.apache.kylin.engine.spark.job.stage.optimize.OptimizeExecutionContext$;
import org.apache.kylin.engine.spark.job.step.StageExec;
import org.apache.kylin.guava30.shaded.common.util.concurrent.RateLimiter;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.metadata.cube.model.NDataLayoutDetails;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001A4A!\u0003\u0006\u00017!Aa\u0005\u0001B\u0001B\u0003%q\u0005C\u0003,\u0001\u0011\u0005A\u0006C\u00030\u0001\u0011\u0005\u0003\u0007C\u0003=\u0001\u0011\u0005S\bC\u0003E\u0001\u0011\u0005S\tC\u0003J\u0001\u0011\u0005S\tC\u0003K\u0001\u0011%1\nC\u0003l\u0001\u0011\u0005CN\u0001\rMCf|W\u000f\u001e#bi\u00064\u0016mY;v[>\u0003H/[7ju\u0016T!a\u0003\u0007\u0002\u0011=\u0004H/[7ju\u0016T!!\u0004\b\u0002\u000bM$\u0018mZ3\u000b\u0005=\u0001\u0012a\u00016pE*\u0011\u0011CE\u0001\u0006gB\f'o\u001b\u0006\u0003'Q\ta!\u001a8hS:,'BA\u000b\u0017\u0003\u0015Y\u0017\u0010\\5o\u0015\t9\u0002$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00023\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\b\u0012\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0003}\tQa]2bY\u0006L!!\t\u0010\u0003\r\u0005s\u0017PU3g!\t\u0019C%D\u0001\u000b\u0013\t)#B\u0001\nMCf|W\u000f^(qi&l\u0017N_3Fq\u0016\u001c\u0017!\u00067bs>,H\u000fR1uC>\u0003H/[7ju\u0016TuN\u0019\t\u0003Q%j\u0011AD\u0005\u0003U9\u0011Q\u0003T1z_V$H)\u0019;b\u001fB$\u0018.\\5{K*{'-\u0001\u0004=S:LGO\u0010\u000b\u0003[9\u0002\"a\t\u0001\t\u000b\u0019\u0012\u0001\u0019A\u0014\u0002\u0019\u001d,Go\u0015;bO\u0016t\u0015-\\3\u0016\u0003E\u0002\"AM\u001d\u000f\u0005M:\u0004C\u0001\u001b\u001f\u001b\u0005)$B\u0001\u001c\u001b\u0003\u0019a$o\\8u}%\u0011\u0001HH\u0001\u0007!J,G-\u001a4\n\u0005iZ$AB*ue&twM\u0003\u00029=\u0005iq-\u001a;K_\n\u001cuN\u001c;fqR,\u0012A\u0010\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003B\t1\"\u00199qY&\u001c\u0017\r^5p]&\u00111\t\u0011\u0002\u0011'B\f'o[!qa2L7-\u0019;j_:\fAb\u001c8Ti\u0006<Wm\u0015;beR$\u0012A\u0012\t\u0003;\u001dK!\u0001\u0013\u0010\u0003\tUs\u0017\u000e^\u0001\bKb,7-\u001e;f\u000311\u0018mY;v[2\u000b\u0017p\\;u)\tau\f\u0005\u0002N9:\u0011aJ\u0017\b\u0003\u001ffs!\u0001\u0015-\u000f\u0005E;fB\u0001*W\u001d\t\u0019VK\u0004\u00025)&\t\u0011$\u0003\u0002\u00181%\u0011QCF\u0005\u0003'QI!!\u0005\n\n\u0005=\u0001\u0012BA.\u000f\u0003-\u0019VmZ7f]R,\u00050Z2\n\u0005us&\u0001\u0006,bGV,Xn\u00149uS6L'0\u001a*fgVdGO\u0003\u0002\\\u001d!)\u0001m\u0002a\u0001C\u0006aA.Y=pkR$U\r^1jYB\u0011!-[\u0007\u0002G*\u0011A-Z\u0001\u0006[>$W\r\u001c\u0006\u0003M\u001e\fAaY;cK*\u0011\u0001\u000eF\u0001\t[\u0016$\u0018\rZ1uC&\u0011!n\u0019\u0002\u0013\u001d\u0012\u000bG/\u0019'bs>,H\u000fR3uC&d7/A\u0004dC:\u001c6.\u001b9\u0016\u00035\u0004\"!\b8\n\u0005=t\"a\u0002\"p_2,\u0017M\u001c")
public class LayoutDataVacuumOptimize
implements LayoutOptimizeExec {
    private final LayoutDataOptimizeJob layoutDataOptimizeJob;
    private LinkedBlockingQueue<Future<SegmentExec.ResultType>> pipe;
    private String stageId;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    @Override
    public <T> void drain(long timeout, TimeUnit unit) {
        LayoutOptimizeExec.drain$(this, timeout, unit);
    }

    @Override
    public <T> long drain$default$1() {
        return LayoutOptimizeExec.drain$default$1$(this);
    }

    @Override
    public <T> TimeUnit drain$default$2() {
        return LayoutOptimizeExec.drain$default$2$(this);
    }

    @Override
    public String getSegmentId() {
        return StageExec.getSegmentId$(this);
    }

    @Override
    public RateLimiter createRateLimiter(double permitsPerSecond) {
        return StageExec.createRateLimiter$(this, permitsPerSecond);
    }

    @Override
    public double createRateLimiter$default$1() {
        return StageExec.createRateLimiter$default$1$(this);
    }

    @Override
    public void onStageFinished(ExecutableState state) {
        StageExec.onStageFinished$(this, state);
    }

    @Override
    public ExecutableState onStageFinished$default$1() {
        return StageExec.onStageFinished$default$1$(this);
    }

    @Override
    public void onStageSkipped() {
        StageExec.onStageSkipped$(this);
    }

    @Override
    public void updateStageInfo(String status, String errMsg, Map<String, String> updateInfo) {
        StageExec.updateStageInfo$(this, status, errMsg, updateInfo);
    }

    @Override
    public String getStageId() {
        return StageExec.getStageId$(this);
    }

    @Override
    public void setStageId(String stageId) {
        StageExec.setStageId$(this, stageId);
    }

    @Override
    public void doExecute() {
        StageExec.doExecute$(this);
    }

    @Override
    public void doExecuteWithoutFinally() {
        StageExec.doExecuteWithoutFinally$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    private LinkedBlockingQueue<Future<SegmentExec.ResultType>> pipe$lzycompute() {
        LayoutDataVacuumOptimize layoutDataVacuumOptimize = this;
        synchronized (layoutDataVacuumOptimize) {
            if (!this.bitmap$0) {
                this.pipe = LayoutOptimizeExec.pipe$(this);
                this.bitmap$0 = true;
            }
        }
        return this.pipe;
    }

    @Override
    public final LinkedBlockingQueue<Future<SegmentExec.ResultType>> pipe() {
        return !this.bitmap$0 ? this.pipe$lzycompute() : this.pipe;
    }

    @Override
    public String stageId() {
        return this.stageId;
    }

    @Override
    public void stageId_$eq(String x$1) {
        this.stageId = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String getStageName() {
        return "delete useless layout data";
    }

    @Override
    public SparkApplication getJobContext() {
        return this.layoutDataOptimizeJob;
    }

    @Override
    public void onStageStart() {
        StageExec.onStageStart$(this);
        this.layoutDataOptimizeJob.getSparkSession().conf().set("spark.databricks.delta.retentionDurationCheck.enabled", "false");
    }

    @Override
    public void execute() {
        if (!this.canSkip()) {
            this.layoutDataOptimizeJob.getLayoutDetails().foreach((Function1 & Serializable & scala.Serializable)layoutDetail -> {
                Object object;
                if (StringUtils.isNotEmpty((CharSequence)layoutDetail.getRangeFilterExpr())) {
                    Future vacuumFuture = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.vacuumLayout((NDataLayoutDetails)layoutDetail), (ExecutionContext)OptimizeExecutionContext$.MODULE$.futureExecutionContext());
                    object = BoxesRunTime.boxToBoolean((boolean)this.pipe().offer((Future<SegmentExec.ResultType>)vacuumFuture));
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            });
            this.drain(this.drain$default$1(), this.drain$default$2());
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Skip stage vacuum layout ").append($this.layoutDataOptimizeJob.dataFlow().getModel().getId()).toString());
        }
    }

    private SegmentExec.VacuumOptimizeResult vacuumLayout(NDataLayoutDetails layoutDetail) {
        String desc = new StringBuilder(14).append("Vacuum layout ").append(layoutDetail.getLayoutId()).toString();
        OptimizeExecutionContext$.MODULE$.setJobDesc(this.getJobContext().getSparkSession(), desc);
        DeltaTable deltaTable = DeltaTable$.MODULE$.forPath(layoutDetail.getLocation());
        String condition = new StringBuilder(6).append("not (").append(layoutDetail.getRangeFilterExpr()).append(")").toString();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Start to delete and vacuum with condition ").append(condition).append(" for ").append(layoutDetail).append(".getLocation").toString());
        deltaTable.delete(condition);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Finished delete and vacuum with condition ").append(condition).append(" for ").append(layoutDetail).append(".getLocation").toString());
        OptimizeExecutionContext$.MODULE$.cancelJobDesc(this.getJobContext().getSparkSession());
        return new SegmentExec.VacuumOptimizeResult(Predef$.MODULE$.long2Long(layoutDetail.getLayoutId()));
    }

    @Override
    public boolean canSkip() {
        return this.layoutDataOptimizeJob.getConfig().isV3SkipVacuumOptimize();
    }

    public LayoutDataVacuumOptimize(LayoutDataOptimizeJob layoutDataOptimizeJob) {
        this.layoutDataOptimizeJob = layoutDataOptimizeJob;
        Logging.$init$((Logging)this);
        StageExec.$init$(this);
        LayoutOptimizeExec.$init$(this);
    }
}

