/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.job.StepExec;
import org.apache.kylin.engine.spark.job.TableAnalyzeExec;
import org.apache.kylin.engine.spark.job.step.TableAnalyzeStage;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils;
import org.apache.spark.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableAnalyzeJob
extends SparkApplication
implements Serializable {
    public static final ImmutableList<String> TABLE_STATS_METRICS = ImmutableList.builder().add((Object[])new String[]{"COUNT", "COUNT_DISTINCT", "MAX", "MIN"}).build();
    private static final Logger logger = LoggerFactory.getLogger(TableAnalyzeJob.class);

    public static void main(String[] args) {
        TableAnalyzeJob job = new TableAnalyzeJob();
        job.execute(args);
    }

    @Override
    protected void doExecute() throws Exception {
        String stepId = StringUtils.replace((String)this.infos.getJobStepId(), (String)"job_step_", (String)"");
        StepExec step = new StepExec(stepId);
        step.addStage(new TableAnalyzeStage(this));
        step.doExecute();
    }

    public void analyzerTable() {
        String tableName = this.getParam("table");
        int rowCount = Integer.parseInt(this.getParam("samplingRows"));
        String prjName = this.getParam("project");
        TableDesc tableDesc = NTableMetadataManager.getInstance((KylinConfig)this.config, (String)this.project).getTableDesc(tableName);
        this.analyzeTable(tableDesc, prjName, rowCount, this.ss);
    }

    public void analyzeTable(TableDesc tableDesc, String project, int rowCount, SparkSession ss) {
        long start = System.currentTimeMillis();
        Row[] row = new TableAnalyzeExec(tableDesc, project, rowCount, ss, this.jobId).analyzeTable();
        logger.info("sampling rows from table {} takes {}s", (Object)tableDesc.getIdentity(), (Object)((System.currentTimeMillis() - start) / 1000L));
        NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        TableExtDesc tableExtDesc = tableMetadataManager.getOrCreateTableExt(tableDesc);
        long count_star = Long.parseLong(row[0].get(0).toString());
        ArrayList<TableExtDesc.ColumnStats> columnStatsList = new ArrayList<TableExtDesc.ColumnStats>(tableDesc.getColumnCount());
        for (int colIdx = 0; colIdx < tableDesc.getColumnCount(); ++colIdx) {
            ColumnDesc columnDesc = tableDesc.getColumns()[colIdx];
            if (columnDesc.isComputedColumn()) continue;
            TableExtDesc.ColumnStats colStats = tableExtDesc.getColumnStatsByName(columnDesc.getName());
            if (colStats == null) {
                colStats = new TableExtDesc.ColumnStats();
                colStats.setColumnName(columnDesc.getName());
            }
            int metricLen = TABLE_STATS_METRICS.size();
            block13: for (int i2 = 0; i2 < metricLen; ++i2) {
                String value = row[0].get(i2 + 1 + metricLen * colIdx) == null ? null : row[0].get(i2 + 1 + metricLen * colIdx).toString();
                switch ((String)TABLE_STATS_METRICS.get(i2)) {
                    case "COUNT": {
                        colStats.setNullCount(count_star - Long.parseLong(value));
                        continue block13;
                    }
                    case "MAX": {
                        colStats.setMaxValue(value);
                        continue block13;
                    }
                    case "MIN": {
                        colStats.setMinValue(value);
                        continue block13;
                    }
                    case "COUNT_DISTINCT": {
                        colStats.setCardinality(Long.parseLong(value));
                        continue block13;
                    }
                    default: {
                        throw new IllegalArgumentException("not support this metric" + (String)TABLE_STATS_METRICS.get(i2) + "in table Sampling");
                    }
                }
            }
            columnStatsList.add(colStats);
        }
        ArrayList sampleData = Lists.newArrayList();
        IntStream.range(1, row.length).forEach(i -> {
            String[] data = new String[row[i].length()];
            IntStream.range(0, row[i].length()).forEach(j -> {
                Object obj = row[i].get(j);
                data[j] = obj == null ? null : (obj instanceof Timestamp ? DateFormat.castTimestampToString((long)((Timestamp)obj).getTime()) : obj.toString());
            });
            sampleData.add(data);
        });
        UnitOfWork.doInTransactionWithRetry(() -> {
            NTableMetadataManager tableMetadataManagerForUpdate = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            TableExtDesc tableExt = tableMetadataManagerForUpdate.getOrCreateTableExt(tableDesc);
            tableExt = tableMetadataManagerForUpdate.copyForWrite(tableExt);
            tableExt.setTotalRows(count_star);
            tableExt.setColumnStats(columnStatsList);
            tableExt.setSampleRows(sampleData);
            tableExt.setJodID(this.jobId);
            tableMetadataManagerForUpdate.saveTableExt(tableExt);
            return null;
        }, (String)project);
        logger.info("Table {} analysis finished, update table ext desc done.", (Object)tableDesc.getName());
    }

    @Override
    protected String calculateRequiredCores() throws Exception {
        String tableName = this.getParam("table");
        Path shareDir = this.config.getJobTmpShareDir(this.project, this.jobId);
        String child = tableName + "_" + ResourceDetectUtils.samplingDetectItemFileSuffix();
        Map detectItems = ResourceDetectUtils.readDetectItems((Path)new Path(shareDir, child));
        return ResourceUtils.caculateRequiredCores(detectItems);
    }
}

