/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.JobErrorCode;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.engine.spark.job.NResourceDetectStep;
import org.apache.kylin.engine.spark.job.NSparkCubingStep;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.job.SparkCleanupTransactionalTableStep;
import org.apache.kylin.engine.spark.job.StepEnum;
import org.apache.kylin.engine.spark.utils.HiveTableRefChecker;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.DefaultExecutableOnModel;
import org.apache.kylin.job.execution.ExecutableParams;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.factory.JobFactory;
import org.apache.kylin.job.handler.AddIndexHandler;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.cube.model.PartitionStatusEnum;
import org.apache.kylin.metadata.job.JobBucket;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkCubingJob
extends DefaultExecutableOnModel {
    private static final Logger logger = LoggerFactory.getLogger(NSparkCubingJob.class);

    public NSparkCubingJob() {
    }

    public NSparkCubingJob(Object notSetId) {
        super(notSetId);
    }

    @VisibleForTesting
    public static NSparkCubingJob create(Set<NDataSegment> segments, Set<LayoutEntity> layouts, String submitter, Set<JobBucket> buckets) {
        return NSparkCubingJob.create(segments, layouts, submitter, JobTypeEnum.INDEX_BUILD, RandomUtil.randomUUIDStr(), null, null, buckets);
    }

    @VisibleForTesting
    public static NSparkCubingJob createIncBuildJob(Set<NDataSegment> segments, Set<LayoutEntity> layouts, String submitter, Set<JobBucket> buckets) {
        return NSparkCubingJob.create(segments, layouts, submitter, JobTypeEnum.INC_BUILD, RandomUtil.randomUUIDStr(), null, null, buckets);
    }

    @VisibleForTesting
    public static NSparkCubingJob create(Set<NDataSegment> segments, Set<LayoutEntity> layouts, String submitter, JobTypeEnum jobType, String jobId, Set<String> ignoredSnapshotTables, Set<Long> partitions, Set<JobBucket> buckets) {
        JobFactory.JobBuildParams params = new JobFactory.JobBuildParams(segments, layouts, submitter, jobType, jobId, null, ignoredSnapshotTables, partitions, buckets, (Map)Maps.newHashMap());
        return NSparkCubingJob.innerCreate(params);
    }

    public static NSparkCubingJob create(JobFactory.JobBuildParams jobBuildParams) {
        NSparkCubingJob sparkCubingJob = NSparkCubingJob.innerCreate(jobBuildParams);
        if (jobBuildParams instanceof AddIndexHandler.AddIndexJobBuildParams) {
            boolean layoutsDeletableAfterBuild = ((AddIndexHandler.AddIndexJobBuildParams)jobBuildParams).isLayoutsDeletableAfterBuild();
            sparkCubingJob.setParam("layoutsDeletableAfterBuild", String.valueOf(layoutsDeletableAfterBuild));
        }
        if (CollectionUtils.isNotEmpty((Collection)jobBuildParams.getToBeDeletedLayouts())) {
            sparkCubingJob.setParam("toBeDeletedLayoutIds", NSparkCubingUtil.ids2Str((Set)NSparkCubingUtil.toLayoutIds((Set)jobBuildParams.getToBeDeletedLayouts())));
        }
        return sparkCubingJob;
    }

    private static NSparkCubingJob innerCreate(JobFactory.JobBuildParams params) {
        String enableAutoIndexPlan;
        Set segments = params.getSegments();
        Set layouts = params.getLayouts();
        String submitter = params.getSubmitter();
        JobTypeEnum jobType = params.getJobType();
        String jobId = params.getJobId();
        Set ignoredSnapshotTables = params.getIgnoredSnapshotTables();
        Set partitions = params.getPartitions();
        Set buckets = params.getBuckets();
        Map extParams = params.getExtParams();
        Preconditions.checkArgument((!segments.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((submitter != null ? 1 : 0) != 0);
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (!kylinConfig.isUTEnv() && !Boolean.parseBoolean(enableAutoIndexPlan = (String)params.getExtParams().get("kylin.planner.autoApproveEnabled"))) {
            Preconditions.checkArgument((!layouts.isEmpty() ? 1 : 0) != 0);
        }
        NDataflow df = ((NDataSegment)segments.iterator().next()).getDataflow();
        NSparkCubingJob job = new NSparkCubingJob();
        long startTime = 0x7FFFFFFFFFFFFFFEL;
        long endTime = 0L;
        for (NDataSegment segment : segments) {
            startTime = Math.min(startTime, Long.parseLong(segment.getSegRange().getStart().toString()));
            endTime = endTime > Long.parseLong(segment.getSegRange().getStart().toString()) ? endTime : Long.parseLong(segment.getSegRange().getEnd().toString());
        }
        job.setParams(extParams);
        job.setId(jobId);
        job.setName(jobType.toString());
        job.setJobType(jobType);
        job.setTargetSubject(((NDataSegment)segments.iterator().next()).getModel().getUuid());
        job.setTargetSegments(segments.stream().map(x -> String.valueOf(x.getId())).collect(Collectors.toList()));
        job.setProject(df.getProject());
        job.setSubmitter(submitter);
        if (CollectionUtils.isNotEmpty((Collection)partitions)) {
            job.setTargetPartitions(partitions);
            job.setParam("partitionIds", job.getTargetPartitions().stream().map(String::valueOf).collect(Collectors.joining(",")));
            NSparkCubingJob.checkIfNeedBuildSnapshots(job);
        }
        if (CollectionUtils.isNotEmpty((Collection)buckets)) {
            job.setParam("buckets", ExecutableParams.toBucketParam((Set)buckets));
        }
        NSparkCubingJob.enableCostBasedPlannerIfNeed(df, segments, job);
        job.setParam("jobId", jobId);
        job.setParam("project", df.getProject());
        job.setParam("targetModel", job.getTargetSubject());
        job.setParam("dataflowId", df.getId());
        job.setParam("layoutIds", NSparkCubingUtil.ids2Str((Set)NSparkCubingUtil.toLayoutIds((Set)layouts)));
        job.setParam("segmentIds", String.join((CharSequence)",", job.getTargetSegments()));
        job.setParam("dataRangeStart", String.valueOf(startTime));
        job.setParam("dataRangeEnd", String.valueOf(endTime));
        if (CollectionUtils.isNotEmpty((Collection)ignoredSnapshotTables)) {
            job.setParam("ignoredSnapshotTables", String.join((CharSequence)",", ignoredSnapshotTables));
        }
        KylinConfigExt config = df.getConfig();
        StepEnum.RESOURCE_DETECT.create((DefaultExecutable)job, (KylinConfig)config);
        StepEnum.CUBING.create((DefaultExecutable)job, (KylinConfig)config);
        StepEnum.UPDATE_METADATA.create((DefaultExecutable)job, (KylinConfig)config);
        NSparkCubingJob.initCleanUpTransactionalTable(kylinConfig, df, job, config);
        if (config.isIndexPreloadCacheEnabled()) {
            StepEnum.LOAD_GLUTEN_CACHE.create((DefaultExecutable)job, (KylinConfig)config);
        }
        return job;
    }

    private static AbstractExecutable initCleanUpTransactionalTable(KylinConfig kylinConfig, NDataflow df, NSparkCubingJob job, KylinConfigExt config) {
        AbstractExecutable cleanUpTransactionalTable = null;
        Boolean isRangePartitionTable = df.getModel().getAllTableRefs().stream().anyMatch(tableRef -> tableRef.getTableDesc().isRangePartition());
        Boolean isTransactionalTable = df.getModel().getAllTableRefs().stream().anyMatch(tableRef -> tableRef.getTableDesc().isTransactional());
        if (HiveTableRefChecker.isNeedCleanUpTransactionalTableJob(isTransactionalTable, isRangePartitionTable, kylinConfig.isReadTransactionalTableEnabled())) {
            cleanUpTransactionalTable = StepEnum.CLEANUP_TRANSACTIONAL_TABLE.create((DefaultExecutable)job, (KylinConfig)config);
        }
        return cleanUpTransactionalTable;
    }

    public static void checkIfNeedBuildSnapshots(NSparkCubingJob job) {
        switch (job.getJobType()) {
            case INC_BUILD: 
            case INDEX_REFRESH: 
            case INDEX_BUILD: {
                job.setParam("needBuildSnapshots", "true");
                break;
            }
            default: {
                job.setParam("needBuildSnapshots", "false");
            }
        }
    }

    public Set<String> getMetadataDumpList(KylinConfig config) {
        String dataflowId = this.getParam("dataflowId");
        return NDataflowManager.getInstance((KylinConfig)config, (String)this.getProject()).getDataflow(dataflowId).collectPrecalculationResource();
    }

    public NSparkCubingStep getSparkCubingStep() {
        return (NSparkCubingStep)this.getTask(NSparkCubingStep.class);
    }

    public NResourceDetectStep getResourceDetectStep() {
        return (NResourceDetectStep)this.getTask(NResourceDetectStep.class);
    }

    public SparkCleanupTransactionalTableStep getCleanIntermediateTableStep() {
        return (SparkCleanupTransactionalTableStep)this.getTask(SparkCleanupTransactionalTableStep.class);
    }

    public void cancelJob() {
        NDataflowManager nDataflowManager = NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject());
        NDataflow dataflow = nDataflowManager.getDataflow(this.getSparkCubingStep().getDataflowId());
        if (dataflow == null) {
            logger.debug("Dataflow is null, maybe model is deleted?");
            return;
        }
        ArrayList<NDataSegment> toRemovedSegments = new ArrayList<NDataSegment>();
        for (String id : this.getSparkCubingStep().getSegmentIds()) {
            NDataSegment segment = dataflow.getSegment(id);
            if (segment == null || SegmentStatusEnum.READY == segment.getStatus() || SegmentStatusEnum.WARNING == segment.getStatus()) continue;
            toRemovedSegments.add(segment);
        }
        if (toRemovedSegments.isEmpty()) {
            logger.warn("Segment related to job {} can not be found, maybe job has been canceled.", (Object)this.getJobId());
            return;
        }
        NDataSegment[] nDataSegments = toRemovedSegments.toArray(new NDataSegment[0]);
        NDataflowUpdate nDataflowUpdate = new NDataflowUpdate(dataflow.getUuid());
        nDataflowUpdate.setToRemoveSegs(nDataSegments);
        NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project).updateDataflow(nDataflowUpdate);
        this.updatePartitionOnCancelJob(nDataflowManager);
    }

    public void updatePartitionOnCancelJob(NDataflowManager dfManager) {
        if (!this.isBucketJob()) {
            return;
        }
        NDataflow df = dfManager.getDataflow(this.getSparkCubingStep().getDataflowId()).copy();
        Set<String> segmentIds = this.getSparkCubingStep().getSegmentIds();
        Set partitions = this.getSparkCubingStep().getTargetPartitions();
        switch (this.getJobType()) {
            case SUB_PARTITION_BUILD: {
                for (String id : segmentIds) {
                    NDataSegment segment = df.getSegment(id);
                    if (segment == null) continue;
                    dfManager.removeLayoutPartition(df.getId(), partitions, (Set)Sets.newHashSet((Object[])new String[]{segment.getId()}));
                    dfManager.removeSegmentPartition(df.getId(), partitions, (Set)Sets.newHashSet((Object[])new String[]{segment.getId()}));
                    logger.info("Remove partitions [{}] in segment [{}] cause to cancel job.", (Object)partitions, (Object)id);
                }
                break;
            }
            case SUB_PARTITION_REFRESH: {
                for (String id : segmentIds) {
                    NDataSegment segment = df.getSegment(id);
                    if (segment == null) continue;
                    segment = segment.copy();
                    segment.getMultiPartitions().forEach(partition -> {
                        if (partitions.contains(partition.getPartitionId()) && PartitionStatusEnum.REFRESH == partition.getStatus()) {
                            partition.setStatus(PartitionStatusEnum.READY);
                        }
                    });
                    NDataflowUpdate dfUpdate = new NDataflowUpdate(df.getId());
                    dfUpdate.setToUpdateSegs(new NDataSegment[]{segment});
                    dfManager.updateDataflow(dfUpdate);
                    logger.info("Change partitions [{}] in segment [{}] status to READY cause to cancel job.", (Object)partitions, (Object)id);
                }
                break;
            }
        }
    }

    public boolean safetyIfDiscard() {
        if (this.checkSuicide() || this.getStatusInMem().isFinalState() || this.getJobType() != JobTypeEnum.INC_BUILD) {
            return true;
        }
        NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject()).getDataflow(this.getSparkCubingStep().getDataflowId());
        List segs = dataflow.getSegments().stream().filter(nDataSegment -> !this.getTargetSegments().contains(nDataSegment.getId())).collect(Collectors.toList());
        List toDeletedSeg = dataflow.getSegments().stream().filter(nDataSegment -> this.getTargetSegments().contains(nDataSegment.getId())).collect(Collectors.toList());
        List segHoles = NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject()).calculateHoles(this.getSparkCubingStep().getDataflowId(), segs);
        for (NDataSegment segHole : segHoles) {
            for (NDataSegment deleteSeg : toDeletedSeg) {
                if (!segHole.getSegRange().overlaps(deleteSeg.getSegRange()) && !segHole.getSegRange().contains(deleteSeg.getSegRange())) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void enableCostBasedPlannerIfNeed(NDataflow df, Set<NDataSegment> segments, NSparkCubingJob job) {
        boolean needCostRecommendIndex;
        IndexPlan indexPlan = df.getIndexPlan();
        KylinConfig kylinConfig = indexPlan.getConfig();
        boolean bl = needCostRecommendIndex = indexPlan.getRuleBasedIndex() != null && indexPlan.getRuleBasedIndex().getLayoutsOfCostBasedList() == null && !indexPlan.getRuleBasedIndex().getAggregationGroups().isEmpty();
        if (!kylinConfig.enableCostBasedIndexPlanner() || !needCostRecommendIndex || !NSparkCubingJob.canEnablePlannerJob(job.getJobType())) return;
        if (segments.size() != 1) throw new KylinException((ErrorCodeSupplier)JobErrorCode.COST_BASED_PLANNER_ERROR, "The number of segments to be built or refreshed must be 1, This is the first time to submit build job with enable cost based planner");
        if (!NSparkCubingJob.noBuildingSegmentExist(df.getProject(), job.getTargetSubject(), kylinConfig)) throw new KylinException((ErrorCodeSupplier)JobErrorCode.COST_BASED_PLANNER_ERROR, "There are running job for this model when submit the build job with cost based planner, please wait for other jobs to finish or cancel them");
        if (indexPlan.getRuleBasedIndex().countOfIncludeDimension() > 63) {
            throw new KylinException((ErrorCodeSupplier)JobErrorCode.COST_BASED_PLANNER_ERROR, String.format(Locale.ROOT, "The count of row key %d can't be larger than 63, when use the cube planner", indexPlan.getRuleBasedIndex().countOfIncludeDimension()));
        }
        job.setParam("enablePlanner", Boolean.TRUE.toString());
    }

    private static boolean noBuildingSegmentExist(String project, String modelId, KylinConfig kylinConfig) {
        NDataflowManager nDataflowManager = NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)project);
        NDataflow dataflow = nDataflowManager.getDataflow(modelId);
        return dataflow.getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.NEW}).size() <= 1;
    }

    private static boolean canEnablePlannerJob(JobTypeEnum jobType) {
        return JobTypeEnum.INC_BUILD == jobType || JobTypeEnum.INDEX_REFRESH == jobType;
    }

    static {
        JobFactory.register((String)"CUBE_JOB_FACTORY", (JobFactory)new CubingJobFactory());
    }

    static class NSparkCubingJobStep {
        private final AbstractExecutable resourceDetect;
        private final AbstractExecutable cubing;
        private final AbstractExecutable updateMetadata;
        private final AbstractExecutable cleanUpTransactionalTable;

        @Generated
        public NSparkCubingJobStep(AbstractExecutable resourceDetect, AbstractExecutable cubing, AbstractExecutable updateMetadata, AbstractExecutable cleanUpTransactionalTable) {
            this.resourceDetect = resourceDetect;
            this.cubing = cubing;
            this.updateMetadata = updateMetadata;
            this.cleanUpTransactionalTable = cleanUpTransactionalTable;
        }

        @Generated
        public AbstractExecutable getResourceDetect() {
            return this.resourceDetect;
        }

        @Generated
        public AbstractExecutable getCubing() {
            return this.cubing;
        }

        @Generated
        public AbstractExecutable getUpdateMetadata() {
            return this.updateMetadata;
        }

        @Generated
        public AbstractExecutable getCleanUpTransactionalTable() {
            return this.cleanUpTransactionalTable;
        }
    }

    static class CubingJobFactory
    extends JobFactory {
        private CubingJobFactory() {
        }

        protected NSparkCubingJob create(JobFactory.JobBuildParams jobBuildParams) {
            return NSparkCubingJob.create(jobBuildParams);
        }
    }
}

