/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.cache.kylin.KylinCacheFileSystem;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.engine.spark.job.IJobProgressReport;
import org.apache.kylin.engine.spark.job.KylinBuildEnv;
import org.apache.kylin.engine.spark.job.SegmentJob;
import org.apache.kylin.engine.spark.job.step.ParamPropagation;
import org.apache.kylin.engine.spark.job.step.build.MaterializeFactView;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.query.plugin.runtime.MppOnTheFlyProvider;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MppOnTheFlyImpl
implements MppOnTheFlyProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MppOnTheFlyImpl.class);

    public LogicalPlan computeMissingLayout(List<NDataSegment> prunedSegments, long layoutId, SparkSession ss) {
        List<NDataSegment> missingLayoutSegs = prunedSegments.stream().filter(seg -> !seg.getLayoutsMap().containsKey(layoutId)).collect(Collectors.toList());
        if (missingLayoutSegs.isEmpty()) {
            return null;
        }
        NDataSegment virtualSeg = this.virtualSegment(missingLayoutSegs);
        KylinCacheFileSystem.setAcceptCacheTimeLocally((long)virtualSeg.getDataflow().getLastModified());
        return this.computeLayout(virtualSeg, layoutId, ss);
    }

    private NDataSegment virtualSegment(List<NDataSegment> missingLayoutSegs) {
        Preconditions.checkState((missingLayoutSegs.size() > 0 ? 1 : 0) != 0);
        SegmentRange merged = null;
        for (NDataSegment seg : missingLayoutSegs) {
            if (merged == null) {
                merged = seg.getSegRange();
                continue;
            }
            merged = merged.coverWith(seg.getSegRange());
        }
        NDataSegment ret = new NDataSegment(missingLayoutSegs.get(0).getDataflow(), merged);
        ret.setId("");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogicalPlan computeLayout(NDataSegment virtualSeg, long layoutId, SparkSession ss) {
        KylinConfigExt config = virtualSeg.getDataflow().getConfig();
        KylinBuildEnv.getOrCreate((KylinConfig)config);
        try {
            LayoutEntity layoutEntity = virtualSeg.getIndexPlan().getLayoutEntity(Long.valueOf(layoutId));
            MockJobContext jobContext = new MockJobContext(virtualSeg, layoutId, ss);
            ParamPropagation params = new ParamPropagation();
            MaterializeFactView tool = new MaterializeFactView(jobContext, virtualSeg, params);
            Dataset<Row> layoutDS = tool.computeLayoutFromSourceAllInOne(layoutEntity);
            LogicalPlan logicalPlan = layoutDS == null ? null : layoutDS.queryExecution().logical();
            return logicalPlan;
        }
        finally {
            KylinBuildEnv.clean();
        }
    }

    public static class MockJobContext
    extends SegmentJob {
        private final NDataSegment seg;

        private MockJobContext(NDataSegment seg, long layoutId, SparkSession ss) {
            this.seg = seg;
            this.ss = ss;
            this.dataflowId = seg.getDataflow().getId();
            this.indexPlan = seg.getIndexPlan();
            this.readOnlySegments = ImmutableSet.of((Object)seg);
            this.readOnlyLayouts = ImmutableSet.of((Object)seg.getIndexPlan().getLayoutEntity(Long.valueOf(layoutId)));
        }

        @Override
        public KylinConfig getConfig() {
            return this.seg.getDataflow().getConfig();
        }

        @Override
        public SparkSession getSparkSession() {
            return this.ss;
        }

        @Override
        public boolean isPartialBuild() {
            return false;
        }

        @Override
        public IJobProgressReport getReport() {
            return new IJobProgressReport(){

                public boolean updateSparkJobInfo(Map<String, String> params, String url, String json) {
                    return false;
                }

                public boolean updateSparkJobExtraInfo(Map<String, String> params, String url, String project, String jobId, Map<String, String> extraInfo) {
                    return false;
                }
            };
        }

        @Override
        protected void doExecute() throws Exception {
        }
    }
}

