/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.engine.spark.builder.DFBuilderHelper$;
import org.apache.kylin.engine.spark.job.DFChooser$;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.metadata.cube.cuboid.NSpanningTree;
import org.apache.kylin.metadata.cube.model.NCubeJoinedFlatTableDesc;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.udaf.EncodeApproxCountDistinct;
import org.apache.spark.sql.udaf.EncodeApproxCountDistinct$;
import org.apache.spark.sql.udaf.EncodePreciseCountDistinct;
import org.apache.spark.sql.udaf.EncodePreciseCountDistinct$;
import org.apache.spark.sql.udaf.EncodeSumLC;
import org.apache.spark.sql.udaf.EncodeSumLC$;
import org.apache.spark.sql.udaf.EncodeTopN;
import org.apache.spark.sql.udaf.EncodeTopN$;
import org.apache.spark.sql.udaf.OptIntersectCount;
import org.apache.spark.sql.udaf.OptIntersectCount$;
import org.apache.spark.sql.udaf.Percentile;
import org.apache.spark.sql.udaf.Percentile$;
import org.apache.spark.sql.udaf.ReuseApproxCountDistinct;
import org.apache.spark.sql.udaf.ReuseApproxCountDistinct$;
import org.apache.spark.sql.udaf.ReusePreciseCountDistinct;
import org.apache.spark.sql.udaf.ReusePreciseCountDistinct$;
import org.apache.spark.sql.udaf.ReuseSumLC;
import org.apache.spark.sql.udaf.ReuseSumLC$;
import org.apache.spark.sql.udaf.ReuseTopN;
import org.apache.spark.sql.udaf.ReuseTopN$;
import org.apache.spark.sql.util.SparderTypeUtil$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

public final class CuboidAggregator$ {
    public static CuboidAggregator$ MODULE$;

    static {
        new CuboidAggregator$();
    }

    public Dataset<Row> agg(Dataset<Row> dataset, Set<Integer> dimensions, Map<Integer, NDataModel.Measure> measures, NDataSegment seg, NSpanningTree spanningTree) {
        NSpanningTree nSpanningTree = spanningTree;
        boolean bl = nSpanningTree == null ? true : DFChooser$.MODULE$.needJoinLookupTables(seg.getModel(), spanningTree);
        boolean needJoin = bl;
        NCubeJoinedFlatTableDesc flatTableDesc = new NCubeJoinedFlatTableDesc(seg.getIndexPlan(), seg.getSegRange(), Predef$.MODULE$.boolean2Boolean(needJoin));
        scala.collection.immutable.Map columnIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataset.schema().fieldNames())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)tp -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)tp._2$mcI$sp()), tp._1()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        return this.aggregate(dataset, dimensions, measures, (Function1<TblColRef, String>)(Function1 & Serializable & scala.Serializable)colRef -> (String)columnIndex.apply((Object)BoxesRunTime.boxToInteger((int)flatTableDesc.getColumnIndex(colRef))), this.aggregate$default$5());
    }

    public Dataset<Row> aggregateJava(Dataset<Row> dataset, Set<Integer> dimensions, Map<Integer, NDataModel.Measure> measures, NCubeJoinedFlatTableDesc tableDesc, boolean isSparkSQL) {
        scala.collection.immutable.Map columnIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataset.schema().fieldNames())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)tp -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)tp._2$mcI$sp()), tp._1()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        return this.aggregate(dataset, dimensions, measures, (Function1<TblColRef, String>)(Function1 & Serializable & scala.Serializable)colRef -> (String)columnIndex.apply((Object)BoxesRunTime.boxToInteger((int)tableDesc.getColumnIndex(colRef))), isSparkSQL);
    }

    public Dataset<Row> aggregate(Dataset<Row> dataset, Set<Integer> dimensions, Map<Integer, NDataModel.Measure> measures, Function1<TblColRef, String> columnIdFunc, boolean isSparkSQL) {
        Dataset dataset2;
        Dataset df;
        Set<Integer> set;
        if (measures.isEmpty()) {
            return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])NSparkCubingUtil.getColumns((Set[])new Set[]{dimensions}))).dropDuplicates();
        }
        boolean reuseLayout = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataset.schema().fieldNames())).contains((Object)((Integer)((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(measures.keySet()).asScala()).head()).toString());
        IntRef taggedColIndex = IntRef.create((int)-1);
        Seq agg = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(measures).asScala()).map((Function1 & Serializable & scala.Serializable)measureEntry -> {
            Column column;
            NDataModel.Measure measure = (NDataModel.Measure)measureEntry._2();
            FunctionDesc function = measure.getFunction();
            List parameters = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(function.getParameters()).asScala()).toList();
            ListBuffer columns = new ListBuffer();
            org.apache.kylin.metadata.datatype.DataType returnType = function.getReturnDataType();
            if (((ParameterDesc)parameters.head()).isColumnType()) {
                if (reuseLayout) {
                    columns.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(((Integer)measureEntry._1()).toString())}));
                } else {
                    columns.appendAll((TraversableOnce)parameters.map((Function1 & Serializable & scala.Serializable)p -> functions$.MODULE$.col((String)columnIdFunc.apply((Object)p.getColRef())), List$.MODULE$.canBuildFrom()));
                }
            } else if (reuseLayout) {
                columns.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(((Integer)measureEntry._1()).toString())}));
            } else {
                String par = ((ParameterDesc)parameters.head()).getValue();
                if (function.getExpression().equalsIgnoreCase("SUM")) {
                    columns.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)par).cast(SparderTypeUtil$.MODULE$.toSparkType(returnType, SparderTypeUtil$.MODULE$.toSparkType$default$2()))}));
                } else {
                    columns.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)par)}));
                }
            }
            String string = function.getExpression().toUpperCase(Locale.ROOT);
            if ("MAX".equals(string)) {
                column = functions$.MODULE$.max((Column)columns.head()).as(((Integer)measureEntry._1()).toString());
            } else if ("MIN".equals(string)) {
                column = functions$.MODULE$.min((Column)columns.head()).as(((Integer)measureEntry._1()).toString());
            } else if ("SUM".equals(string)) {
                column = functions$.MODULE$.sum((Column)columns.head()).as(((Integer)measureEntry._1()).toString());
            } else if ("COUNT".equals(string)) {
                column = reuseLayout ? functions$.MODULE$.sum((Column)columns.head()).as(((Integer)measureEntry._1()).toString()) : functions$.MODULE$.count((Column)columns.head()).as(((Integer)measureEntry._1()).toString());
            } else if ("COUNT_DISTINCT".equals(string)) {
                Column column2;
                if (isSparkSQL) {
                    column2 = functions$.MODULE$.countDistinct((Column)columns.head(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).as(((Integer)measureEntry._1()).toString());
                } else {
                    Column cdCol = (Column)columns.head();
                    boolean isBitmap = returnType.getName().equalsIgnoreCase("bitmap");
                    boolean isHllc = returnType.getName().startsWith("hllc");
                    if (isBitmap && parameters.size() == 2) {
                        Predef$.MODULE$.require(measures.size() == 1, (Function0 & Serializable & scala.Serializable)() -> "Opt intersect count can only has one measure.");
                        if (!reuseLayout) {
                            taggedColIndex$1.elem = new StringOps(Predef$.MODULE$.augmentString((String)columnIdFunc.apply((Object)((ParameterDesc)parameters.last()).getColRef()))).toInt();
                            Column tagCol = functions$.MODULE$.col(Integer.toString(taggedColIndex$1.elem));
                            String separator = KapConfig.getInstanceFromEnv().getIntersectCountSeparator();
                            cdCol = MODULE$.wrapEncodeColumn((Column)columns.head());
                            column2 = new Column((Expression)new OptIntersectCount(cdCol.expr(), functions$.MODULE$.split(tagCol, new StringBuilder(1).append("\\").append(separator).toString()).expr(), OptIntersectCount$.MODULE$.apply$default$3(), OptIntersectCount$.MODULE$.apply$default$4()).toAggregateExpression()).as(new StringBuilder(4).append("map_").append(((Integer)measureEntry._1()).toString()).toString());
                        } else {
                            column2 = new Column((Expression)new ReusePreciseCountDistinct(cdCol.expr(), ReusePreciseCountDistinct$.MODULE$.apply$default$2(), ReusePreciseCountDistinct$.MODULE$.apply$default$3()).toAggregateExpression()).as(((Integer)measureEntry._1()).toString());
                        }
                    } else if (!reuseLayout) {
                        if (isBitmap) {
                            cdCol = MODULE$.wrapEncodeColumn((Column)columns.head());
                            column2 = new Column((Expression)new EncodePreciseCountDistinct(cdCol.expr(), EncodePreciseCountDistinct$.MODULE$.apply$default$2(), EncodePreciseCountDistinct$.MODULE$.apply$default$3()).toAggregateExpression()).as(((Integer)measureEntry._1()).toString());
                        } else if (columns.length() > 1 && isHllc) {
                            cdCol = MODULE$.wrapMutilHllcColumn((Seq<Column>)columns);
                            column2 = new Column((Expression)new EncodeApproxCountDistinct(cdCol.expr(), returnType.getPrecision(), EncodeApproxCountDistinct$.MODULE$.apply$default$3(), EncodeApproxCountDistinct$.MODULE$.apply$default$4()).toAggregateExpression()).as(((Integer)measureEntry._1()).toString());
                        } else {
                            column2 = new Column((Expression)new EncodeApproxCountDistinct(cdCol.expr(), returnType.getPrecision(), EncodeApproxCountDistinct$.MODULE$.apply$default$3(), EncodeApproxCountDistinct$.MODULE$.apply$default$4()).toAggregateExpression()).as(((Integer)measureEntry._1()).toString());
                        }
                    } else if (isBitmap) {
                        column2 = new Column((Expression)new ReusePreciseCountDistinct(cdCol.expr(), ReusePreciseCountDistinct$.MODULE$.apply$default$2(), ReusePreciseCountDistinct$.MODULE$.apply$default$3()).toAggregateExpression()).as(((Integer)measureEntry._1()).toString());
                    } else if (columns.length() > 1 && isHllc) {
                        cdCol = MODULE$.wrapMutilHllcColumn((Seq<Column>)columns);
                        column2 = new Column((Expression)new ReuseApproxCountDistinct(cdCol.expr(), returnType.getPrecision(), ReuseApproxCountDistinct$.MODULE$.apply$default$3(), ReuseApproxCountDistinct$.MODULE$.apply$default$4()).toAggregateExpression()).as(((Integer)measureEntry._1()).toString());
                    } else {
                        column2 = new Column((Expression)new ReuseApproxCountDistinct(cdCol.expr(), returnType.getPrecision(), ReuseApproxCountDistinct$.MODULE$.apply$default$3(), ReuseApproxCountDistinct$.MODULE$.apply$default$4()).toAggregateExpression()).as(((Integer)measureEntry._1()).toString());
                    }
                }
                column = column2;
            } else if ("TOP_N".equals(string)) {
                ColumnDesc measure2 = ((ParameterDesc)function.getParameters().get(0)).getColRef().getColumnDesc();
                StructType schema = StructType$.MODULE$.apply((Seq)((List)parameters.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getColRef().getColumnDesc(), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)col -> {
                    DataType dateType = SparderTypeUtil$.MODULE$.toSparkType(col.getType(), SparderTypeUtil$.MODULE$.toSparkType$default$2());
                    ColumnDesc columnDesc = col;
                    ColumnDesc columnDesc2 = measure2;
                    return !(columnDesc != null ? !columnDesc.equals(columnDesc2) : columnDesc2 != null) ? new StructField(new StringBuilder(8).append("MEASURE_").append(col.getName()).toString(), dateType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()) : new StructField(new StringBuilder(10).append("DIMENSION_").append(col.getName()).toString(), dateType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                }, List$.MODULE$.canBuildFrom()));
                column = reuseLayout ? new Column((Expression)new ReuseTopN(returnType.getPrecision(), schema, ((Column)columns.head()).expr(), ReuseTopN$.MODULE$.apply$default$4(), ReuseTopN$.MODULE$.apply$default$5()).toAggregateExpression()).as(((Integer)measureEntry._1()).toString()) : new Column((Expression)new EncodeTopN(returnType.getPrecision(), schema, ((Column)columns.head()).expr(), (Seq)((TraversableLike)columns.drop(1)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.expr(), ListBuffer$.MODULE$.canBuildFrom()), EncodeTopN$.MODULE$.apply$default$5(), EncodeTopN$.MODULE$.apply$default$6()).toAggregateExpression()).as(((Integer)measureEntry._1()).toString());
            } else if ("PERCENTILE_APPROX".equals(string)) {
                column = new Column((Expression)new Percentile(((Column)columns.head()).expr(), returnType.getPrecision(), Percentile$.MODULE$.apply$default$3(), Percentile$.MODULE$.apply$default$4(), Percentile$.MODULE$.apply$default$5(), Percentile$.MODULE$.apply$default$6()).toAggregateExpression()).as(((Integer)measureEntry._1()).toString());
            } else if ("COLLECT_SET".equals(string)) {
                column = reuseLayout ? functions$.MODULE$.array_distinct(functions$.MODULE$.flatten(functions$.MODULE$.collect_set((Column)columns.head()))).as(((Integer)measureEntry._1()).toString()) : functions$.MODULE$.collect_set((Column)columns.head()).as(((Integer)measureEntry._1()).toString());
            } else if ("CORR".equals(string)) {
                column = new Column((Expression)new Literal(null, (DataType)DoubleType$.MODULE$)).as(((Integer)measureEntry._1()).toString());
            } else if ("SUM_LC".equals(string)) {
                org.apache.kylin.metadata.datatype.DataType colDataType = function.getReturnDataType();
                DataType sparkDataType = SparderTypeUtil$.MODULE$.toSparkType(colDataType, SparderTypeUtil$.MODULE$.toSparkType$default$2());
                column = reuseLayout ? new Column((Expression)new ReuseSumLC(((Column)columns.head()).expr(), sparkDataType, ReuseSumLC$.MODULE$.apply$default$3(), ReuseSumLC$.MODULE$.apply$default$4(), ReuseSumLC$.MODULE$.apply$default$5()).toAggregateExpression()).as(((Integer)measureEntry._1()).toString()) : new Column((Expression)new EncodeSumLC(((Column)columns.head()).expr(), ((Column)((TraversableForwarder)columns.drop(1)).head()).expr(), sparkDataType, EncodeSumLC$.MODULE$.apply$default$4(), EncodeSumLC$.MODULE$.apply$default$5(), EncodeSumLC$.MODULE$.apply$default$6()).toAggregateExpression()).as(((Integer)measureEntry._1()).toString());
            } else {
                throw new MatchError((Object)string);
            }
            return column;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        if (taggedColIndex.elem != -1 && !reuseLayout) {
            HashSet<Integer> d = new HashSet<Integer>(dimensions);
            d.remove(BoxesRunTime.boxToInteger((int)taggedColIndex.elem));
            set = d;
        } else {
            set = dimensions;
        }
        Set<Integer> dim = set;
        Dataset dataset3 = df = !dim.isEmpty() ? dataset.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])NSparkCubingUtil.getColumns((Set[])new Set[]{dim}))).agg((Column)agg.head(), (Seq)agg.drop(1)) : dataset.agg((Column)agg.head(), (Seq)agg.drop(1));
        if (reuseLayout) {
            Column[] columns = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])NSparkCubingUtil.getColumns((Set[])new Set[]{dimensions}))).$plus$plus(this.measureColumns(dataset.schema(), measures), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
            dataset2 = df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])columns));
        } else if (taggedColIndex.elem != -1) {
            String icCol = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fieldNames())).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains("map"))))).head();
            String[] fieldsWithoutIc = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fieldNames())).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CuboidAggregator$.$anonfun$aggregate$8(icCol, x$4)));
            String cdMeasureName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])icCol.split("_"))).last();
            String[] newSchema = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldsWithoutIc)).$colon$plus((Object)Integer.toString(taggedColIndex.elem), ClassTag$.MODULE$.apply(String.class)))).$colon$plus((Object)cdMeasureName, ClassTag$.MODULE$.apply(String.class));
            Column[] exploded = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldsWithoutIc)).map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).$colon$plus((Object)functions$.MODULE$.explode(functions$.MODULE$.col(icCol)), ClassTag$.MODULE$.apply(Column.class));
            dataset2 = df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])exploded)).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])newSchema));
        } else {
            dataset2 = df;
        }
        return dataset2;
    }

    public boolean aggregateJava$default$5() {
        return false;
    }

    public boolean aggregate$default$5() {
        return false;
    }

    private Iterable<Column> measureColumns(StructType schema, Map<Integer, NDataModel.Measure> measures) {
        return (Iterable)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(measures).asScala()).map((Function1 & Serializable & scala.Serializable)mea -> {
            Column column;
            String measureId = ((Integer)mea._1()).toString();
            String string = ((MeasureDesc)mea._2()).getFunction().getExpression().toUpperCase(Locale.ROOT);
            if ("SUM".equals(string)) {
                DataType dataType = ((StructField)schema.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CuboidAggregator$.$anonfun$measureColumns$2(measureId, x$5))).get()).dataType();
                column = functions$.MODULE$.col(measureId).cast(dataType).as(measureId);
            } else {
                column = functions$.MODULE$.col(measureId);
            }
            return column;
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public Column wrapEncodeColumn(Column column) {
        return new Column(new StringBuilder(0).append(column.toString()).append(DFBuilderHelper$.MODULE$.ENCODE_SUFFIX()).toString());
    }

    public Column wrapMutilHllcColumn(Seq<Column> columns) {
        ObjectRef col = ObjectRef.create((Object)functions$.MODULE$.when(functions$.MODULE$.isnull((Column)columns.head()), null));
        ((IterableLike)columns.drop(1)).foreach((Function1 & Serializable & scala.Serializable)inputCol -> {
            col.elem = ((Column)col.elem).when(functions$.MODULE$.isnull(inputCol), null);
            return BoxedUnit.UNIT;
        });
        col.elem = ((Column)col.elem).otherwise((Object)functions$.MODULE$.hash(columns));
        return (Column)col.elem;
    }

    public static final /* synthetic */ boolean $anonfun$aggregate$8(String icCol$1, String x$4) {
        return !x$4.contains(icCol$1);
    }

    public static final /* synthetic */ boolean $anonfun$measureColumns$2(String measureId$1, StructField x$5) {
        return x$5.name().equals(measureId$1);
    }

    private CuboidAggregator$() {
        MODULE$ = this;
    }
}

