/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.builder.DFLayoutMergeAssist;
import org.apache.kylin.engine.spark.job.DFMergeJob;
import org.apache.kylin.engine.spark.job.LogJobInfoUtils;
import org.apache.kylin.engine.spark.job.ResourceDetect;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.Segments;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterator;
import scala.collection.JavaConversions;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class BeforeSegmentMergeJob
extends SparkApplication
implements ResourceDetect {
    protected static final Logger logger = LoggerFactory.getLogger(BeforeSegmentMergeJob.class);

    @Override
    protected void doExecute() throws Exception {
        String dataflowId = this.getParam("dataflowId");
        NDataflowManager mgr = NDataflowManager.getInstance((KylinConfig)this.config, (String)this.project);
        NDataflow dataflow = mgr.getDataflow(dataflowId);
        NDataSegment mergedSeg = dataflow.getSegment(this.getParam("segmentIds"));
        Segments mergingSegments = dataflow.getMergingSegments(mergedSeg);
        this.infos.clearMergingSegments();
        Collections.sort(mergingSegments);
        this.infos.recordMergingSegments((List<NDataSegment>)mergingSegments);
        Map<Long, DFLayoutMergeAssist> mergeCuboidsAssist = DFMergeJob.generateMergeAssist((List<NDataSegment>)mergingSegments, this.ss, mergedSeg);
        ResourceDetectUtils.write((Path)new Path(this.config.getJobTmpShareDir(this.project, this.jobId), ResourceDetectUtils.countDistinctSuffix()), (Object)ResourceDetectUtils.findCountDistinctMeasure((Collection)mergedSeg.getIndexPlan().getAllLayouts()));
        HashMap resourceSize = Maps.newHashMap();
        this.infos.clearSparkPlans();
        for (Map.Entry<Long, DFLayoutMergeAssist> entry : mergeCuboidsAssist.entrySet()) {
            Dataset<Row> afterMerge = entry.getValue().merge();
            this.infos.recordSparkPlan(afterMerge.queryExecution().sparkPlan());
            List paths = JavaConversions.seqAsJavaList((Seq)ResourceDetectUtils.getPaths((SparkPlan)afterMerge.queryExecution().sparkPlan(), (boolean)true));
            resourceSize.put(String.valueOf(entry.getKey()), ResourceDetectUtils.getResourceSize((KylinConfig)this.config, (Configuration)SparderEnv.getHadoopConfiguration(), (Seq)((Iterator)JavaConverters.asScalaIteratorConverter(paths.iterator()).asScala()).toSeq()));
        }
        ResourceDetectUtils.write((Path)new Path(this.config.getJobTmpShareDir(this.project, this.jobId), mergedSeg.getId() + "_" + ResourceDetectUtils.fileName()), (Object)resourceSize);
    }

    @Override
    protected String generateInfo() {
        return LogJobInfoUtils.resourceDetectBeforeMergingJobInfo();
    }

    @Override
    protected void waitForResourceSuccess() {
    }

    public static void main(String[] args) {
        BeforeSegmentMergeJob resourceDetectJob = new BeforeSegmentMergeJob();
        resourceDetectJob.execute(args);
    }
}

