/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.List;
import lombok.Generated;
import org.apache.calcite.rel.RelNode;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.cuboid.NLookupCandidate;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapRel;
import org.apache.kylin.query.relnode.OlapTableScan;
import org.apache.kylin.query.util.ICutContextStrategy;
import org.apache.kylin.query.util.QueryContextCutter;

public class ContextReCutStrategy
implements ICutContextStrategy {
    private ICutContextStrategy.ContextCutImpl reCutter;

    public List<OlapRel> cutOffContext(OlapRel rootRel, RelNode parentOfRoot) {
        for (OlapTableScan tableScan : rootRel.getContext().getAllTableScans()) {
            tableScan.setColumnRowType(null);
        }
        OlapContext originCtx = rootRel.getContext();
        this.reCutter.visitChild((RelNode)rootRel);
        ContextUtil.clearThreadLocalContextById((int)originCtx.getId());
        return Lists.newArrayList((Object[])new OlapRel[]{rootRel});
    }

    public boolean needCutOff(OlapRel rootRel) {
        return rootRel.getContext() != null && rootRel.getContext().isHasJoin();
    }

    void tryCutToSmallerContexts(RelNode root, RuntimeException e) {
        ICutContextStrategy.ContextCutImpl cutter = this.getReCutter() == null ? new ICutContextStrategy.ContextCutImpl(ContextUtil.getThreadLocalContexts().size()) : new ICutContextStrategy.ContextCutImpl(this.getReCutter().getCtxSeq());
        this.setReCutter(cutter);
        ContextUtil.listContextsHavingScan().stream().filter(context -> context.deduceLookupTableType() == NLookupCandidate.Policy.NONE).forEach(context -> {
            if (context.isHasSelected() && context.getRealization() == null && (!context.isHasPreCalcJoin() || context.getBoundedModelAlias() != null)) {
                throw e;
            }
            if (context.isHasSelected() && context.getRealization() == null) {
                QueryContextCutter.cutContext(this, context.getTopNode(), root);
                ContextUtil.setSubContexts((RelNode)root.getInput(0));
                return;
            }
            if (context.getRealization() != null) {
                context.unfixModel();
            }
            context.clearCtxInfo();
        });
    }

    @Generated
    public ICutContextStrategy.ContextCutImpl getReCutter() {
        return this.reCutter;
    }

    @Generated
    public void setReCutter(ICutContextStrategy.ContextCutImpl reCutter) {
        this.reCutter = reCutter;
    }
}

