/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.blacklist;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kylin.common.util.RandomUtil;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class SQLBlacklistItem
implements Serializable {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="regex")
    private String regex;
    @JsonProperty(value="sql")
    private String sql;
    @JsonProperty(value="concurrent_limit")
    private int concurrentLimit;
    private Pattern pattern;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void updateRandomUuid() {
        this.setId(RandomUtil.randomUUIDStr());
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
        if (null != this.regex) {
            this.pattern = Pattern.compile(regex);
        }
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public boolean match(String sql) {
        if (null != this.sql && this.sql.equals(sql)) {
            return true;
        }
        if (null == this.regex) {
            return false;
        }
        if (null == this.pattern) {
            this.pattern = Pattern.compile(this.regex);
        }
        Matcher matcher = this.pattern.matcher(sql);
        return matcher.matches();
    }

    public int getConcurrentLimit() {
        return this.concurrentLimit;
    }

    public void setConcurrentLimit(int concurrentLimit) {
        this.concurrentLimit = concurrentLimit;
    }
}

