/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.job.domain.JobInfo;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.manager.JobManager;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.TableSamplingSupporter;
import org.apache.kylin.rest.util.AclEvaluate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TableSampleService
extends BasicService
implements TableSamplingSupporter {
    @Autowired
    private AclEvaluate aclEvaluate;

    public boolean hasSamplingJob(String project, String table) {
        this.aclEvaluate.checkProjectWritePermission(project);
        return CollectionUtils.isNotEmpty(this.existingRunningSamplingJobs(project, table));
    }

    private List<JobInfo> existingRunningSamplingJobs(String project, String table) {
        return ExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).fetchNotFinalJobsByTypes(project, (List)Lists.newArrayList((Object[])new String[]{JobTypeEnum.TABLE_SAMPLING.name()}), (List)Lists.newArrayList((Object[])new String[]{table}));
    }

    public List<String> sampling(Set<String> tables, String project, int rows, int priority, String yarnQueue, Object tag) {
        this.aclEvaluate.checkProjectWritePermission(project);
        ArrayList jobIds = Lists.newArrayList();
        for (String table : tables) {
            JobParam jobParam = new JobParam().withOwner(TableSampleService.getUsername()).withTable(table).withProject(project).withYarnQueue(yarnQueue).withPriority(priority).withJobTypeEnum(JobTypeEnum.TABLE_SAMPLING).withTag(tag).addExtParams("samplingRows", String.valueOf(rows));
            jobIds.add(((JobManager)this.getManager(JobManager.class, project)).addJob(jobParam));
        }
        return jobIds;
    }
}

