/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.engine.spark.builder.InternalTableLoader;
import org.apache.kylin.engine.spark.job.InternalTableLoadJob;
import org.apache.kylin.engine.spark.job.InternalTableUpdateMetadataStep;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.dao.JobStatisticsManager;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.manager.JobManager;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.sourceusage.SourceUsageManager;
import org.apache.kylin.metadata.table.InternalTableDesc;
import org.apache.kylin.metadata.table.InternalTableManager;
import org.apache.kylin.metadata.table.InternalTablePartition;
import org.apache.kylin.metadata.table.InternalTablePartitionDetail;
import org.apache.kylin.rest.response.InternalTableLoadingJobResponse;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.util.DataRangeUtils;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="internalTableLoadingService")
public class InternalTableLoadingService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(InternalTableLoadingService.class);

    public InternalTableLoadingJobResponse loadIntoInternalTable(String project, String table, String database, boolean isIncremental, boolean isRefresh, String startDate, String endDate, String[] partitions, String yarnQueue) {
        JobManager.checkStorageQuota((String)project);
        ArrayList<String> jobIds = new ArrayList<String>();
        JobTypeEnum jobType = isRefresh ? JobTypeEnum.INTERNAL_TABLE_REFRESH : JobTypeEnum.INTERNAL_TABLE_BUILD;
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            JobManager.checkStorageQuota((String)project);
            JobStatisticsManager jobStatisticsManager = JobStatisticsManager.getInstance((KylinConfig)this.getConfig(), (String)project);
            jobStatisticsManager.updateStatistics(TimeUtil.getDayStart((long)System.currentTimeMillis()), 0L, 0L, 1);
            InternalTableDesc internalTable = this.checkAndGetInternalTables(project, table, database);
            InternalTableManager internalTableManager = InternalTableManager.getInstance((KylinConfig)this.getConfig(), (String)project);
            if (isRefresh && null != partitions && partitions.length > 0) {
                SparkSession ss = (SparkSession)SparkSession.getDefaultSession().get();
                InternalTableLoader internalTableLoader = new InternalTableLoader();
                internalTableLoader.loadInternalTable(ss, internalTable, new String[]{startDate, endDate}, partitions, internalTable.getStorageType().getFormat(), isIncremental);
            } else {
                this.checkBeforeSubmit(internalTable, jobType, isIncremental, isRefresh, startDate, endDate);
                logger.info("create internal table loading job for table: {}, isIncrementBuild: {}, startTime: {}, endTime: {}", new Object[]{internalTable.getIdentity(), isIncremental, startDate, endDate});
                JobParam jobParam = new JobParam().withProject(project).withTable(internalTable.getIdentity()).withYarnQueue(yarnQueue).withJobTypeEnum(jobType).withOwner(BasicService.getUsername()).addExtParams("incrementalBuild", String.valueOf(isIncremental)).addExtParams("outputMode", String.valueOf(isRefresh)).addExtParams("startTime", startDate).addExtParams("endTime", endDate);
                String jobId = (String)((SourceUsageManager)this.getManager(SourceUsageManager.class)).licenseCheckWrap(project, () -> ((JobManager)this.getManager(JobManager.class, project)).addJob(jobParam));
                jobIds.add(jobId);
                internalTableManager.saveOrUpdateInternalTable(internalTable);
            }
            return true;
        }, (String)project);
        String jobName = isRefresh ? JobTypeEnum.INTERNAL_TABLE_REFRESH.toString() : JobTypeEnum.INTERNAL_TABLE_BUILD.toString();
        return InternalTableLoadingJobResponse.of(jobIds, jobName);
    }

    private void checkBeforeSubmit(InternalTableDesc internalTable, JobTypeEnum jobType, boolean isIncremental, boolean isRefresh, String startDate, String endDate) throws KylinException {
        String errorMsg;
        String timeFmt;
        if (isIncremental && (Objects.isNull(internalTable.getTablePartition()) || Objects.isNull(internalTable.getTablePartition().getPartitionColumns()) || internalTable.getTablePartition().getPartitionColumns().length == 0)) {
            String errorMsg2 = String.format(Locale.ROOT, MsgPicker.getMsg().getInternalTableUnpartitioned(), new Object[0]);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INTERNAL_TABLE_ERROR, errorMsg2);
        }
        InternalTablePartition tablePartition = internalTable.getTablePartition();
        List jobRange = internalTable.getJobRange();
        String[] curJobRange = new String[]{"0", "0"};
        String string = timeFmt = Objects.isNull(tablePartition) ? "" : tablePartition.getDatePartitionFormat();
        if (StringUtils.isNotEmpty((CharSequence)startDate) && StringUtils.isNotEmpty((CharSequence)timeFmt)) {
            SimpleDateFormat fmt = new SimpleDateFormat(timeFmt, Locale.ROOT);
            String start = StringUtils.isEmpty((CharSequence)startDate) ? "0" : fmt.format(Long.parseLong(startDate));
            String end = StringUtils.isEmpty((CharSequence)endDate) ? "0" : fmt.format(Long.parseLong(endDate));
            curJobRange = new String[]{start, end};
        }
        if (isIncremental && !Objects.isNull(tablePartition) && StringUtils.isEmpty((CharSequence)tablePartition.getDatePartitionFormat())) {
            errorMsg = String.format(Locale.ROOT, MsgPicker.getMsg().getNonTimeInternalTableIncrementalBuild(), new Object[0]);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INTERNAL_TABLE_ERROR, errorMsg);
        }
        if (DataRangeUtils.timeOverlap((List)internalTable.getJobRange(), (String[])curJobRange, (String)timeFmt)) {
            errorMsg = String.format(Locale.ROOT, MsgPicker.getMsg().getTimeRangeOverlap(), new Object[0]);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INTERNAL_TABLE_ERROR, errorMsg);
        }
        if (isRefresh && !DataRangeUtils.timeInRange((String[])curJobRange, (List)internalTable.getPartitionRange(), (String)timeFmt)) {
            errorMsg = String.format(Locale.ROOT, MsgPicker.getMsg().getTimeOutOfRange(), new Object[0]);
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INTERNAL_TABLE_ERROR, errorMsg);
        }
        logger.info(jobType.getCategory());
        jobRange.add(curJobRange);
        internalTable.setJobRange(jobRange);
    }

    public void dropPartitions(String project, String[] partitionValues, String tableIdentity, String yarnQueue) throws IOException {
        InternalTableDesc internalTable = this.checkAndGetInternalTables(project, tableIdentity);
        this.checkInternalTablePartitions(internalTable, partitionValues);
        InternalTableLoader internalTableLoader = new InternalTableLoader();
        String toBeDelete = String.join((CharSequence)",", partitionValues);
        SparkSession ss = SparderEnv.getSparkSession();
        long start = System.currentTimeMillis();
        logger.info("Start to drop partition for table {}", (Object)tableIdentity);
        internalTableLoader.dropPartitions(ss, internalTable, toBeDelete);
        InternalTableUpdateMetadataStep metaUpdate = new InternalTableUpdateMetadataStep();
        InternalTableLoadJob.InternalTableMetaUpdateInfo info = metaUpdate.extractUpdateInfo(project, internalTable.getIdentity(), this.getConfig(), ss);
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            InternalTableManager internalTableManager = InternalTableManager.getInstance((KylinConfig)this.getConfig(), (String)project);
            InternalTableDesc oldTable = this.checkAndGetInternalTables(project, tableIdentity);
            InternalTablePartition tablePartition = oldTable.getTablePartition();
            tablePartition.setPartitionValues(info.getPartitionValues());
            tablePartition.setPartitionDetails(info.getPartitionDetails());
            oldTable.setRowCount(info.getFinalCount());
            internalTableManager.saveOrUpdateInternalTable(oldTable);
            return true;
        }, (String)project);
        logger.info("Successfully drop partition[{}] for table {} in {} ms", new Object[]{toBeDelete, tableIdentity, System.currentTimeMillis() - start});
    }

    private InternalTableDesc checkAndGetInternalTables(String project, String tableIdentity) {
        InternalTableManager manager = (InternalTableManager)this.getManager(InternalTableManager.class, project);
        InternalTableDesc internalTable = manager.getInternalTableDesc(tableIdentity);
        if (internalTable == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INTERNAL_TABLE_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getInternalTableNotFound(), tableIdentity));
        }
        return internalTable;
    }

    private InternalTableDesc checkAndGetInternalTables(String project, String table, String database) {
        String dbTableName = database + "." + table;
        return this.checkAndGetInternalTables(project, dbTableName);
    }

    private void checkInternalTablePartitions(InternalTableDesc internalTable, String[] partitionValues) {
        InternalTablePartition internalTablePartition = internalTable.getTablePartition();
        if (null == internalTablePartition || null == internalTablePartition.getPartitionDetails()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INTERNAL_TABLE_PARTITION_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getInternalTablePartitionNotFound(), StringUtils.join((Object[])partitionValues, (char)',')));
        }
        HashSet partitionValueSet = Sets.newHashSet((Object[])partitionValues);
        List partitionList = internalTablePartition.getPartitionDetails();
        for (InternalTablePartitionDetail partitionDetail : partitionList) {
            partitionValueSet.remove(partitionDetail.getPartitionValue());
        }
        if (!partitionValueSet.isEmpty()) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INTERNAL_TABLE_PARTITION_NOT_EXIST, String.format(Locale.ROOT, MsgPicker.getMsg().getInternalTablePartitionNotFound(), StringUtils.join((Iterable)partitionValueSet, (char)',')));
        }
    }
}

