/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HashFunction {
    MD5("MD5"),
    SHA1("SHA1"),
    SHA256("SHA-256"),
    SHA512("SHA-512");

    private static final Logger logger;
    private String name;

    private HashFunction(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] checksum(File input) {
        try (FileInputStream inputStream = new FileInputStream(input);){
            byte[] byArray = this.checksum(inputStream);
            return byArray;
        }
        catch (Exception e) {
            logger.error("Failed to checksum and return null: input={}", (Object)input.getAbsolutePath(), (Object)e);
            return new byte[]{1, 1, 1};
        }
    }

    public byte[] checksum(InputStream in) throws IOException {
        try {
            int length;
            MessageDigest digester = MessageDigest.getInstance(this.getName());
            byte[] block = new byte[4096];
            while ((length = in.read(block)) > 0) {
                digester.update(block, 0, length);
            }
            return digester.digest();
        }
        catch (Exception e) {
            logger.error("Failed to checksum and return null.", (Throwable)e);
            return new byte[]{1, 1, 1};
        }
    }

    static {
        logger = LoggerFactory.getLogger(HashFunction.class);
    }
}

