/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.loader;

import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.loader.AddToClassPathAction;
import org.apache.kylin.loader.ParserClassLoader;
import org.apache.kylin.loader.utils.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserClassLoaderState {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ParserClassLoaderState.class);
    private final String project;
    private Set<String> loadedJars = Sets.newCopyOnWriteArraySet();
    private volatile ClassLoader classLoader;
    private static final Map<String, ParserClassLoaderState> instanceMap = Maps.newConcurrentMap();

    private ParserClassLoaderState(String project) {
        this.project = project;
        ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
        AddToClassPathAction action = new AddToClassPathAction(parentLoader, Collections.emptyList(), true);
        ParserClassLoader parserClassLoader = AccessController.doPrivileged(action);
        this.setClassLoader(parserClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ParserClassLoaderState getInstance(String project) {
        if (instanceMap.getOrDefault(project, null) != null) return instanceMap.get(project);
        Class<ParserClassLoaderState> clazz = ParserClassLoaderState.class;
        synchronized (ParserClassLoaderState.class) {
            if (instanceMap.getOrDefault(project, null) != null) return instanceMap.get(project);
            instanceMap.put(project, new ParserClassLoaderState(project));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instanceMap.get(project);
        }
    }

    public void registerJars(Set<String> newJars) {
        try {
            if (ClassLoaderUtils.judgeIntersection(this.loadedJars, newJars)) {
                throw new IllegalArgumentException("There is already a jar to load " + newJars + ", please ensure that the jar will not be loaded twice");
            }
            AddToClassPathAction addAction = new AddToClassPathAction(this.getClassLoader(), newJars);
            ParserClassLoader parserClassLoader = AccessController.doPrivileged(addAction);
            this.loadedJars.addAll(newJars);
            this.setClassLoader(parserClassLoader);
            log.info("Load Jars: {}", newJars);
        }
        catch (Exception e) {
            this.loadedJars.removeAll(newJars);
            throw new IllegalArgumentException("Unable to register: " + newJars, e);
        }
    }

    public void unregisterJar(Set<String> unregisterJars) {
        try {
            ClassLoaderUtils.removeFromClassPath(this.project, unregisterJars.toArray(new String[0]), this.getClassLoader());
            this.loadedJars.removeAll(unregisterJars);
            log.info("Unload Jars: {}", unregisterJars);
        }
        catch (Exception e) {
            log.error("Unable to unregister {}", unregisterJars, (Object)e);
            throw new IllegalArgumentException("Unable to unregister: " + unregisterJars, e);
        }
    }

    public Set<String> getLoadedJars() {
        return this.loadedJars;
    }

    public void setLoadedJars(Set<String> loadedJars) {
        this.loadedJars = loadedJars;
    }

    public synchronized ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public synchronized void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

