/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;

public class TimeUtil {
    private static long ONE_MINUTE_TS = 60000L;
    private static long ONE_HOUR_TS = 60L * ONE_MINUTE_TS;
    private static final ImmutableMap<String, TimeUnit> timeSuffixes = ImmutableMap.builder().put((Object)"us", (Object)TimeUnit.MICROSECONDS).put((Object)"ms", (Object)TimeUnit.MILLISECONDS).put((Object)"s", (Object)TimeUnit.SECONDS).put((Object)"m", (Object)TimeUnit.MINUTES).put((Object)"min", (Object)TimeUnit.MINUTES).put((Object)"h", (Object)TimeUnit.HOURS).put((Object)"d", (Object)TimeUnit.DAYS).build();

    public static long getMinuteStart(long ts) {
        return ts / ONE_MINUTE_TS * ONE_MINUTE_TS;
    }

    public static long getHourStart(long ts) {
        return ts / ONE_HOUR_TS * ONE_HOUR_TS;
    }

    public static int getHour(long ts) {
        return (int)((ts - TimeUtil.getDayStart(ts)) / ONE_HOUR_TS);
    }

    public static long getDayStart(long ts) {
        ZoneId zoneId = TimeZone.getDefault().toZoneId();
        LocalDate localDate = Instant.ofEpochMilli(ts).atZone(zoneId).toLocalDate();
        return localDate.atStartOfDay().atZone(zoneId).toInstant().toEpochMilli();
    }

    public static long getWeekStart(long ts) {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        calendar.setTimeInMillis(TimeUtil.getDayStart(ts));
        calendar.add(7, calendar.getFirstDayOfWeek() - calendar.get(7));
        return calendar.getTimeInMillis();
    }

    public static long getMonthStart(long ts) {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        calendar.setTimeInMillis(ts);
        int year = calendar.get(1);
        int month = calendar.get(2);
        calendar.clear();
        calendar.set(year, month, 1);
        return calendar.getTimeInMillis();
    }

    public static long getQuarterStart(long ts) {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        calendar.setTimeInMillis(ts);
        int year = calendar.get(1);
        int month = calendar.get(2);
        calendar.clear();
        calendar.set(year, month / 3 * 3, 1);
        return calendar.getTimeInMillis();
    }

    public static long getYearStart(long ts) {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault());
        calendar.setTimeInMillis(ts);
        int year = calendar.get(1);
        calendar.clear();
        calendar.set(year, 0, 1);
        return calendar.getTimeInMillis();
    }

    public static long timeStringAs(String str, TimeUnit unit) {
        String lower = str.toLowerCase(Locale.ROOT).trim();
        try {
            Matcher m = Pattern.compile("(-?[0-9]+)([a-z]+)?").matcher(lower);
            if (!m.matches()) {
                throw new NumberFormatException("Failed to parse time string: " + str);
            }
            long val = Long.parseLong(m.group(1));
            String suffix = m.group(2);
            if (suffix != null && !timeSuffixes.containsKey((Object)suffix)) {
                throw new NumberFormatException("Invalid suffix: \"" + suffix + "\"");
            }
            return unit.convert(val, suffix != null ? (TimeUnit)((Object)timeSuffixes.get((Object)suffix)) : unit);
        }
        catch (NumberFormatException e) {
            String timeError = "Time must be specified as seconds (s), milliseconds (ms), microseconds (us), minutes (m or min), hour (h), or day (d). E.g. 50s, 100ms, or 250us.";
            throw new NumberFormatException(timeError + "\n" + e.getMessage());
        }
    }

    public static long minusDays(long ts, int days) {
        ZoneId zoneId = TimeZone.getDefault().toZoneId();
        ZonedDateTime zonedDateTime = Instant.ofEpochMilli(ts).atZone(zoneId);
        return zonedDateTime.minusDays(days).toInstant().toEpochMilli();
    }

    public static String ymdintBetween(long timestamp1, long timestamp2) {
        ZoneId zoneId = TimeZone.getDefault().toZoneId();
        LocalDate date1 = Instant.ofEpochMilli(timestamp1).atZone(zoneId).toLocalDate();
        LocalDate date2 = Instant.ofEpochMilli(timestamp2).atZone(zoneId).toLocalDate();
        Period between = Period.between(date1, date2);
        return String.format(Locale.ROOT, "%d%02d%02d", Math.abs(between.getYears()), Math.abs(between.getMonths()), Math.abs(between.getDays()));
    }
}

