/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;

public class SecretKeyUtil {
    private static final String STRING_ENCODE = "UTF-8";
    private static final String ENCRYPTION_ALGORITHM_AES = "AES";
    private static final String ENCRYPTION_ALGORITHM_MD5 = "MD5";
    @VisibleForTesting
    public static final String KG_SECRET_KEY_FILE_NAME = "kg_secret_key";
    private static SecretKey kgSecretKey = null;

    public static byte[] encryptToken(SecretKey secretKey, String token) throws Exception {
        Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM_AES);
        cipher.init(1, secretKey);
        byte[] byteContent = token.getBytes(STRING_ENCODE);
        return cipher.doFinal(byteContent);
    }

    public static String decryptToken(SecretKey secretKey, byte[] encryptedToken) throws Exception {
        Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM_AES);
        cipher.init(2, secretKey);
        byte[] result = cipher.doFinal(encryptedToken);
        return new String(result, STRING_ENCODE);
    }

    public static byte[] encryptToken(String key, String token) throws Exception {
        MessageDigest md = MessageDigest.getInstance(ENCRYPTION_ALGORITHM_MD5);
        byte[] digest = md.digest(key.getBytes(STRING_ENCODE));
        SecretKeySpec keySpec = new SecretKeySpec(digest, ENCRYPTION_ALGORITHM_AES);
        return SecretKeyUtil.encryptToken(keySpec, token);
    }

    public static String decryptToken(String key, byte[] encryptedToken) throws Exception {
        MessageDigest md = MessageDigest.getInstance(ENCRYPTION_ALGORITHM_MD5);
        byte[] digest = md.digest(key.getBytes(STRING_ENCODE));
        SecretKeySpec keySpec = new SecretKeySpec(digest, ENCRYPTION_ALGORITHM_AES);
        return SecretKeyUtil.decryptToken(keySpec, encryptedToken);
    }

    public static void initKGSecretKey() throws IOException, NoSuchAlgorithmException {
        File kgSecretKeyFile = new File(KylinConfig.getKylinHome(), KG_SECRET_KEY_FILE_NAME);
        if (kgSecretKeyFile.exists()) {
            Files.delete(kgSecretKeyFile.toPath());
        }
        if (null == kgSecretKey) {
            kgSecretKey = SecretKeyUtil.generateNewAESKey();
        }
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(kgSecretKeyFile));){
            bos.write(kgSecretKey.getEncoded());
        }
    }

    public static void checkKGSecretKeyFile() throws IOException, NoSuchAlgorithmException {
        File kgSecretKeyFile = new File(KylinConfig.getKylinHome(), KG_SECRET_KEY_FILE_NAME);
        if (kgSecretKeyFile.exists()) {
            return;
        }
        SecretKeyUtil.initKGSecretKey();
    }

    public static SecretKey getKGSecretKey() {
        return kgSecretKey;
    }

    public static SecretKey readKGSecretKeyFromFile() throws IOException {
        File kgSecretKeyFile = new File(KylinConfig.getKylinHome(), KG_SECRET_KEY_FILE_NAME);
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(kgSecretKeyFile));){
            byte[] keyBytes = new byte[16];
            if (bis.read(keyBytes) < 1) {
                throw new RuntimeException(String.format(Locale.ROOT, "%s file is empty!", KG_SECRET_KEY_FILE_NAME));
            }
            SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, ENCRYPTION_ALGORITHM_AES);
            return secretKeySpec;
        }
    }

    public static SecretKey generateNewAESKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(ENCRYPTION_ALGORITHM_AES);
        keyGenerator.init(128, new SecureRandom());
        return keyGenerator.generateKey();
    }

    public static byte[] generateEncryptedTokenWithPid(SecretKey kgSecretKey, String kylinPid) throws Exception {
        return SecretKeyUtil.encryptToken(kgSecretKey, kylinPid + "_" + System.currentTimeMillis());
    }
}

