/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.persistence.InMemResourceStore;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.metadata.FileSystemMetadataStore;
import org.apache.kylin.common.persistence.transaction.ITransactionManager;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.SimpleTransactionStatus;

public class FileTransactionHelper
implements ITransactionManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileTransactionHelper.class);
    private final FileSystemMetadataStore store;
    private final ThreadLocal<Set<ReentrantLock>> OWNED_LOCKS = ThreadLocal.withInitial(HashSet::new);
    private final ConcurrentHashMap<String, ReentrantLock> LOCK_MAP = new ConcurrentHashMap();

    public FileTransactionHelper(FileSystemMetadataStore store) {
        this.store = store;
    }

    @Override
    public TransactionStatus getTransaction() throws TransactionException {
        return new SimpleTransactionStatus();
    }

    @Override
    public void commit(TransactionStatus status) throws TransactionException {
        this.releaseOwnedLocks();
    }

    @Override
    public void rollback(TransactionStatus status) throws TransactionException {
        KylinConfig conf = KylinConfig.readSystemKylinConfig();
        InMemResourceStore mem = (InMemResourceStore)ResourceStore.getKylinMetaStore(conf);
        Set<String> changesResource = UnitOfWork.get().getCopyForWriteItems();
        for (String resPath : changesResource) {
            RawResource raw = mem.getResource(resPath);
            Pair<MetadataType, String> typeAndKey = MetadataType.splitKeyWithType(resPath);
            if (raw == null) {
                raw = RawResource.constructResource(typeAndKey.getFirst(), null, 0L, -1L, typeAndKey.getSecond());
            }
            this.store.save(typeAndKey.getFirst(), raw);
            log.info("Rollback metadata for FileSystemMetadataStore: " + resPath);
        }
        this.releaseOwnedLocks();
    }

    public void lockResource(String lockPath) {
        ReentrantLock lock = this.LOCK_MAP.computeIfAbsent(lockPath, k -> new ReentrantLock());
        log.debug("LOCK: try to lock path " + lockPath);
        if (this.OWNED_LOCKS.get().contains(lock)) {
            log.debug("LOCK: already locked " + lockPath);
        } else {
            try {
                if (!lock.tryLock(1L, TimeUnit.MINUTES)) {
                    log.debug("LOCK: failed to lock for " + lockPath);
                    throw new LockTimeoutException(lockPath);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new KylinRuntimeException(e);
            }
            log.debug("LOCK: locked " + lockPath);
            this.OWNED_LOCKS.get().add(lock);
        }
    }

    private void releaseOwnedLocks() {
        this.OWNED_LOCKS.get().forEach(ReentrantLock::unlock);
        log.debug("LOCK: release lock count " + this.OWNED_LOCKS.get().size());
        this.OWNED_LOCKS.get().clear();
    }

    static class LockTimeoutException
    extends RuntimeException {
        public LockTimeoutException(String lockUnit) {
            super(lockUnit);
        }
    }
}

