/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemFilterFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileSystemFilterFactory.class);
    static final String MATCH_ALL_EVAL = "*";

    public static FilterContext convertConditionsToFilter(RawResourceFilter filter, MetadataType type) {
        FilterConversionContext context = new FilterConversionContext(type);
        if (filter != null) {
            for (RawResourceFilter.Condition condition : filter.getConditions()) {
                FileSystemFilterFactory.processCondition(condition, context);
            }
        }
        return FileSystemFilterFactory.buildResult(context);
    }

    private static void processCondition(RawResourceFilter.Condition condition, FilterConversionContext context) {
        FileSystemFilterFactory.create(condition).process(context);
    }

    private static FilterContext buildResult(FilterConversionContext context) {
        String regex = context.buildPathFilterRegex();
        String resPath = context.buildResPath();
        return new FilterContext(resPath, regex, context.getJsonFilterConditions(), context.isWholePath());
    }

    private static ConditionProcessor create(RawResourceFilter.Condition condition) {
        return new SimpleConditionProcessor(condition);
    }

    private static class SimpleConditionProcessor
    implements ConditionProcessor {
        private final RawResourceFilter.Condition condition;

        public SimpleConditionProcessor(RawResourceFilter.Condition condition) {
            this.validate(condition);
            this.condition = condition;
        }

        @Override
        public void validate(RawResourceFilter.Condition condition) {
            if (condition == null || condition.getOp() == null || condition.getValues() == null) {
                throw new KylinRuntimeException("Can not convert condition to filter: " + (condition == null ? "null" : condition.getName()));
            }
        }

        @Override
        public void process(FilterConversionContext context) {
            boolean isMetaKey = "metaKey".equals(this.condition.getName());
            switch (this.condition.getOp()) {
                case EQUAL: {
                    if (isMetaKey && !context.hasWholeKey) {
                        context.setKeyPath(this.condition.getValues().get(0).toString());
                        break;
                    }
                    if (isMetaKey) break;
                    context.addJsonFilterCondition(this.condition);
                    break;
                }
                case EQUAL_CASE_INSENSITIVE: {
                    if (isMetaKey && !context.hasWholeKey) {
                        this.condition.setEval("(?i)" + Pattern.quote(this.condition.getValues().get(0).toString() + ".json"));
                        context.setMetaKeyPathCondition(this.condition);
                        break;
                    }
                    if (isMetaKey) break;
                    context.addJsonFilterCondition(this.condition);
                    break;
                }
                case LIKE_CASE_INSENSITIVE: {
                    if (isMetaKey && !context.hasWholeKey) {
                        this.condition.setEval(String.format(Locale.ROOT, "(?i).*%s.*", Pattern.quote(this.condition.getValues().get(0).toString())));
                        context.setMetaKeyPathCondition(this.condition);
                        break;
                    }
                    if (isMetaKey) break;
                    context.addJsonFilterCondition(this.condition);
                    break;
                }
                case IN: {
                    if (isMetaKey && !context.hasWholeKey) {
                        this.condition.setEval(this.condition.getValues().stream().map(x -> Pattern.quote(x + ".json")).collect(Collectors.joining("|")));
                        context.setMetaKeyPathCondition(this.condition);
                        break;
                    }
                    if (isMetaKey) break;
                    context.addJsonFilterCondition(this.condition);
                    break;
                }
                default: {
                    context.addJsonFilterCondition(this.condition);
                }
            }
        }
    }

    private static interface ConditionProcessor {
        public void validate(RawResourceFilter.Condition var1);

        public void process(FilterConversionContext var1);
    }

    private static class FilterConversionContext {
        private final MetadataType type;
        private boolean hasWholeKey = false;
        private String keyPath = null;
        private final RawResourceFilter jsonFilterConditions = new RawResourceFilter();
        private RawResourceFilter.Condition pathFilterConditions = null;

        public FilterConversionContext(MetadataType type) {
            this.type = type;
        }

        public void setKeyPath(String keyPath) {
            this.keyPath = keyPath;
            this.hasWholeKey = true;
        }

        public void addJsonFilterCondition(RawResourceFilter.Condition condition) {
            this.jsonFilterConditions.addConditions(condition);
        }

        public void setMetaKeyPathCondition(RawResourceFilter.Condition condition) {
            this.pathFilterConditions = condition;
        }

        public String buildResPath() {
            return this.isWholePath() ? this.type.name() + "/" + this.keyPath + ".json" : this.type.name();
        }

        public String buildPathFilterRegex() {
            if (this.isWholePath()) {
                return null;
            }
            return this.pathFilterConditions == null ? null : this.pathFilterConditions.getEval();
        }

        public boolean isWholePath() {
            return this.hasWholeKey;
        }

        @Generated
        public RawResourceFilter getJsonFilterConditions() {
            return this.jsonFilterConditions;
        }
    }

    public static class FilterContext {
        private String resPath;
        private String regex;
        private RawResourceFilter rawResourceFilter;
        private boolean isWholePath;

        @Generated
        public String getResPath() {
            return this.resPath;
        }

        @Generated
        public String getRegex() {
            return this.regex;
        }

        @Generated
        public RawResourceFilter getRawResourceFilter() {
            return this.rawResourceFilter;
        }

        @Generated
        public boolean isWholePath() {
            return this.isWholePath;
        }

        @Generated
        public void setResPath(String resPath) {
            this.resPath = resPath;
        }

        @Generated
        public void setRegex(String regex) {
            this.regex = regex;
        }

        @Generated
        public void setRawResourceFilter(RawResourceFilter rawResourceFilter) {
            this.rawResourceFilter = rawResourceFilter;
        }

        @Generated
        public void setWholePath(boolean isWholePath) {
            this.isWholePath = isWholePath;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FilterContext)) {
                return false;
            }
            FilterContext other = (FilterContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$resPath = this.getResPath();
            String other$resPath = other.getResPath();
            if (this$resPath == null ? other$resPath != null : !this$resPath.equals(other$resPath)) {
                return false;
            }
            String this$regex = this.getRegex();
            String other$regex = other.getRegex();
            if (this$regex == null ? other$regex != null : !this$regex.equals(other$regex)) {
                return false;
            }
            RawResourceFilter this$rawResourceFilter = this.getRawResourceFilter();
            RawResourceFilter other$rawResourceFilter = other.getRawResourceFilter();
            if (this$rawResourceFilter == null ? other$rawResourceFilter != null : !this$rawResourceFilter.equals(other$rawResourceFilter)) {
                return false;
            }
            return this.isWholePath() == other.isWholePath();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FilterContext;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $resPath = this.getResPath();
            result = result * 59 + ($resPath == null ? 43 : $resPath.hashCode());
            String $regex = this.getRegex();
            result = result * 59 + ($regex == null ? 43 : $regex.hashCode());
            RawResourceFilter $rawResourceFilter = this.getRawResourceFilter();
            result = result * 59 + ($rawResourceFilter == null ? 43 : $rawResourceFilter.hashCode());
            result = result * 59 + (this.isWholePath() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "FileSystemFilterFactory.FilterContext(resPath=" + this.getResPath() + ", regex=" + this.getRegex() + ", rawResourceFilter=" + this.getRawResourceFilter() + ", isWholePath=" + this.isWholePath() + ")";
        }

        @Generated
        public FilterContext(String resPath, String regex, RawResourceFilter rawResourceFilter, boolean isWholePath) {
            this.resPath = resPath;
            this.regex = regex;
            this.rawResourceFilter = rawResourceFilter;
            this.isWholePath = isWholePath;
        }
    }
}

