/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.InMemResourceStore;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.TombRawResource;
import org.apache.kylin.common.persistence.metadata.JdbcMetadataStore;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;

public class TransparentResourceStore
extends ResourceStore {
    private final List<RawResource> resources;
    private final InMemResourceStore underlying;
    private final InMemResourceStore overlay;
    private final boolean needToComputeRawDiff;

    public TransparentResourceStore(InMemResourceStore underlying, KylinConfig kylinConfig) {
        super(kylinConfig);
        this.underlying = underlying;
        this.overlay = new InMemResourceStore(kylinConfig);
        this.metadataStore = underlying.getMetadataStore();
        this.resources = Lists.newArrayList();
        this.needToComputeRawDiff = kylinConfig.isAuditLogJsonPatchEnabled() && this.metadataStore instanceof JdbcMetadataStore && (kylinConfig.isUTEnv() || !UnitOfWork.get().isSkipAuditLog());
    }

    @Override
    public MetadataStore getMetadataStore() {
        return this.metadataStore;
    }

    @Override
    protected NavigableSet<String> listResourcesImpl(String folderPath, RawResourceFilter filter, boolean recursive) {
        NavigableSet<String> fromUnderlying = this.underlying.listResourcesImpl(folderPath, filter, recursive);
        NavigableSet<String> fromOverlay = this.overlay.listResourcesImpl(folderPath, filter, recursive);
        TreeSet<String> ret = new TreeSet<String>();
        if (fromUnderlying != null) {
            ret.addAll(fromUnderlying);
        }
        if (fromOverlay != null) {
            ret.addAll(fromOverlay);
        }
        if (!folderPath.equals(MetadataType.ALL.name()) || recursive) {
            ret.removeIf(key -> this.overlay.getResourceImpl((String)key, false) == TombRawResource.getINSTANCE());
        }
        return ret;
    }

    @Override
    protected boolean existsImpl(String resPath) {
        RawResource overlayResource = this.overlay.getResourceImpl(resPath, false);
        if (overlayResource != null) {
            return overlayResource != TombRawResource.getINSTANCE();
        }
        return this.underlying.exists(resPath);
    }

    @Override
    public int batchLock(MetadataType type, RawResourceFilter filter) {
        return this.getMetadataStore().get(type, filter, true, false).size();
    }

    @Override
    protected RawResource getResourceImpl(String resPath, boolean needLock) {
        return this.getResourceImpl(resPath, needLock, true);
    }

    private RawResource getResourceImpl(String resPath, boolean needLock, boolean needContent) {
        if (!needLock) {
            return this.getResourceFromCache(resPath);
        }
        Pair<MetadataType, String> metaKeyAndType = MetadataType.splitKeyWithType(resPath);
        MetadataType type = metaKeyAndType.getFirst();
        String metaKey = metaKeyAndType.getSecond();
        RawResourceFilter filter = RawResourceFilter.equalFilter("metaKey", metaKey);
        List raw = this.getMetadataStore().get(type, filter, needLock, needContent);
        RawResource rawResource = raw.size() == 1 ? (RawResource)raw.get(0) : null;
        this.updateOverlay(resPath, rawResource);
        return rawResource;
    }

    private void updateOverlay(String resPath, RawResource resource) {
        if (resource == null) {
            this.overlay.putTomb(resPath);
        } else {
            this.overlay.putResourceWithoutCheck(resPath, resource.getByteSource(), resource.getTs(), resource.getMvcc(), true);
        }
    }

    private RawResource getResourceFromCache(String resPath) {
        RawResource r = this.overlay.getResourceImpl(resPath, false);
        if (r != null) {
            return r == TombRawResource.getINSTANCE() ? null : r;
        }
        return this.underlying.getResourceImpl(resPath, false);
    }

    @Override
    public RawResource checkAndPutResource(String resPath, ByteSource byteSource, long oldMvcc) {
        return this.checkAndPutResource(resPath, byteSource, System.currentTimeMillis(), oldMvcc);
    }

    @Override
    public RawResource checkAndPutResource(String resPath, ByteSource byteSource, long timeStamp, long oldMvcc) {
        Pair<MetadataType, String> metaKeyAndType = MetadataType.splitKeyWithType(resPath);
        MetadataType type = metaKeyAndType.getFirst();
        RawResource raw = RawResource.constructResource(type, byteSource);
        assert (raw != null);
        raw.setMvcc(oldMvcc + 1L);
        raw.setTs(timeStamp);
        raw.setMetaKey(metaKeyAndType.getSecond());
        int affect = this.getMetadataStore().save(type, raw);
        if (affect == 1) {
            if (this.needToComputeRawDiff) {
                RawResource before = this.getResource(resPath);
                raw.fillContentDiffFromRaw(before);
            }
            this.updateOverlay(resPath, raw);
            this.resources.add(raw);
            return raw;
        }
        throw new IllegalStateException("Update metadata failed.");
    }

    @Override
    protected void deleteResourceImpl(String resPath) {
        Pair<MetadataType, String> metaKeyAndType = MetadataType.splitKeyWithType(resPath);
        MetadataType type = metaKeyAndType.getFirst();
        String metaKey = metaKeyAndType.getSecond();
        RawResource raw = RawResource.constructResource(type, null);
        raw.setMetaKey(metaKey);
        this.getMetadataStore().save(type, raw);
        this.updateOverlay(resPath, null);
        this.resources.add(new TombRawResource(raw.getMetaKey(), raw.getMetaType()));
    }

    @Override
    protected String getReadableResourcePathImpl(String resPath) {
        return this.toString() + ":" + resPath;
    }

    @Override
    public void reload() {
        throw new NotImplementedException("ThreadViewResourceStore doesn't support reload");
    }

    public String toString() {
        return "<thread view metastore@" + System.identityHashCode(this) + ":KylinConfig@" + System.identityHashCode(this.kylinConfig.base()) + ">";
    }

    @Generated
    public List<RawResource> getResources() {
        return this.resources;
    }
}

