/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.IOException;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.TombVersionedRawResource;
import org.apache.kylin.common.persistence.VersionConflictException;
import org.apache.kylin.common.persistence.VersionedRawResource;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemResourceStore
extends ResourceStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InMemResourceStore.class);
    private static final Logger logger = LoggerFactory.getLogger(InMemResourceStore.class);
    private final Map<MetadataType, Map<String, VersionedRawResource>> data = new ConcurrentHashMap<MetadataType, Map<String, VersionedRawResource>>();

    public InMemResourceStore(KylinConfig kylinConfig) {
        super(kylinConfig);
        MetadataType.NEED_CACHED_METADATA.forEach(type -> {
            Map cfr_ignored_0 = this.data.put((MetadataType)((Object)type), MetadataType.CASE_INSENSITIVE_METADATA.contains(type) ? new ConcurrentSkipListMap(String.CASE_INSENSITIVE_ORDER) : new ConcurrentHashMap());
        });
    }

    @Override
    protected NavigableSet<String> listResourcesImpl(String folderPath, RawResourceFilter filter, boolean recursive) {
        if (!MetadataType.ALL_TYPE_STR.contains(folderPath)) {
            throw new IllegalArgumentException("listResourcesImpl params must be a metadata type name, but got: " + folderPath);
        }
        TreeSet<String> ret = new TreeSet<String>();
        MetadataType type = MetadataType.valueOf(folderPath);
        if (type == MetadataType.ALL) {
            if (recursive) {
                MetadataType.NEED_CACHED_METADATA.forEach(t -> ret.addAll(this.listResourcesImpl(t.name(), filter, false)));
            } else {
                MetadataType.NEED_CACHED_METADATA.forEach(t -> ret.add(t.name()));
            }
        } else {
            this.data.get((Object)type).entrySet().stream().filter(entity -> filter.isMatch(((VersionedRawResource)entity.getValue()).getRawResource())).forEach(entity -> ret.add(MetadataType.mergeKeyWithType((String)entity.getKey(), type)));
        }
        return ret;
    }

    @Override
    protected boolean existsImpl(String resPath) {
        return this.getResourceImpl(resPath, false) != null;
    }

    @Override
    public int batchLock(MetadataType type, RawResourceFilter filter) {
        return 0;
    }

    @Override
    protected RawResource getResourceImpl(String resPath, boolean needLock) {
        Pair<MetadataType, String> metaKeyAndType = MetadataType.splitKeyWithType(resPath);
        if (!MetadataType.NEED_CACHED_METADATA.contains((Object)metaKeyAndType.getFirst())) {
            return null;
        }
        VersionedRawResource orDefault = this.data.get((Object)metaKeyAndType.getFirst()).getOrDefault(metaKeyAndType.getSecond(), null);
        if (orDefault == null) {
            return null;
        }
        return orDefault.getRawResource();
    }

    protected void putTomb(String resPath) {
        Pair<MetadataType, String> metaKeyAndType = MetadataType.splitKeyWithType(resPath);
        this.data.get((Object)metaKeyAndType.getFirst()).put(metaKeyAndType.getSecond(), TombVersionedRawResource.getINSTANCE());
    }

    @Override
    public RawResource checkAndPutResource(String resPath, ByteSource byteSource, long oldMvcc) {
        return this.checkAndPutResource(resPath, byteSource, System.currentTimeMillis(), oldMvcc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawResource checkAndPutResource(String resPath, ByteSource byteSource, long timeStamp, long oldMvcc) {
        this.checkEnv();
        Pair<MetadataType, String> meteKeyAndType = MetadataType.splitKeyWithType(resPath);
        MetadataType type = meteKeyAndType.getFirst();
        String metaKey = meteKeyAndType.getSecond();
        RawResource r = RawResource.constructResource(type, byteSource);
        r.setMetaKey(metaKey);
        r.setTs(timeStamp);
        r.setMvcc(oldMvcc + 1L);
        if (!this.data.get((Object)type).containsKey(metaKey)) {
            if (oldMvcc != -1L) {
                throw new IllegalStateException("Trying to update a non-exist meta entry: " + resPath + ", with mvcc: " + oldMvcc);
            }
            Map<MetadataType, Map<String, VersionedRawResource>> map = this.data;
            synchronized (map) {
                if (!this.data.get((Object)type).containsKey(metaKey)) {
                    this.data.get((Object)type).put(metaKey, new VersionedRawResource(r));
                    return r;
                }
            }
        }
        VersionedRawResource versionedRawResource = this.data.get((Object)type).get(metaKey);
        try {
            versionedRawResource.update(r);
        }
        catch (VersionConflictException e) {
            logger.info("current RS: {}", (Object)this);
            throw e;
        }
        return r;
    }

    protected long getResourceMvcc(String resPath) {
        Pair<MetadataType, String> meteKeyAndType = MetadataType.splitKeyWithType(resPath);
        MetadataType type = meteKeyAndType.getFirst();
        String metaKey = meteKeyAndType.getSecond();
        if (!this.data.get((Object)type).containsKey(metaKey)) {
            return -1L;
        }
        if (this.data.get((Object)type).get(metaKey) == TombVersionedRawResource.getINSTANCE()) {
            throw new IllegalStateException();
        }
        VersionedRawResource versionedRawResource = this.data.get((Object)type).get(metaKey);
        return versionedRawResource.getMvcc();
    }

    @Override
    protected void deleteResourceImpl(String resPath) {
        this.checkEnv();
        Pair<MetadataType, String> meteKeyAndType = MetadataType.splitKeyWithType(resPath);
        this.data.get((Object)meteKeyAndType.getFirst()).remove(meteKeyAndType.getSecond());
    }

    @Override
    protected String getReadableResourcePathImpl(String resPath) {
        return this.toString() + ":" + resPath;
    }

    public String toString() {
        return "<in memory metastore@" + System.identityHashCode(this) + ":kylin config@" + System.identityHashCode(this.kylinConfig.base()) + ">";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putResourceWithoutCheck(String resPath, ByteSource bs, long timeStamp, long newMvcc, boolean force) {
        Pair<MetadataType, String> meteKeyAndType = MetadataType.splitKeyWithType(resPath);
        MetadataType type = meteKeyAndType.getFirst();
        String metaKey = meteKeyAndType.getSecond();
        Map<MetadataType, Map<String, VersionedRawResource>> map = this.data;
        synchronized (map) {
            if (!force && this.kylinConfig.isJobNode() && this.data.get((Object)type).containsKey(metaKey)) {
                throw new IllegalStateException("resource " + resPath + " already exists, use check and put api instead");
            }
            RawResource rawResource = RawResource.constructResource(type, bs);
            rawResource.setMvcc(newMvcc);
            rawResource.setTs(timeStamp);
            rawResource.setMetaKey(metaKey);
            this.data.get((Object)type).put(metaKey, new VersionedRawResource(rawResource));
        }
    }

    @Override
    public void reload() throws IOException {
        this.resetData(this.metadataStore.reloadAll());
    }

    public void resetData(MetadataStore.MemoryMetaData metaData) {
        Map<MetadataType, Map<String, VersionedRawResource>> replaceData = metaData.getData();
        MetadataType.NEED_CACHED_METADATA.forEach(type -> this.data.replace((MetadataType)((Object)type), (Map<String, VersionedRawResource>)replaceData.get(type)));
        if (metaData.containOffset()) {
            this.offset = metaData.getOffset();
        }
    }

    private void checkEnv() {
        if (!this.kylinConfig.isSystemConfig() || this.kylinConfig.isUTEnv() || UnitOfWork.isReplaying() || this.kylinConfig.getStreamingChangeMeta()) {
            return;
        }
        Preconditions.checkState((!UnitOfWork.isReadonly() ? 1 : 0) != 0, (Object)"cannot update or delete resource in a readonly transaction");
        throw new IllegalStateException("cannot update or delete resource");
    }

    @Generated
    public Map<MetadataType, Map<String, VersionedRawResource>> getData() {
        return this.data;
    }
}

