/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.mail;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.kylin.common.mail.MailNotificationType;
import org.apache.kylin.guava30.shaded.common.base.Joiner;

public class MailNotificationCreator {
    private static final String MAIL_TITLE_PREFIX = "Kylin System Notification";

    private MailNotificationCreator() {
        throw new IllegalStateException("Utility class");
    }

    public static String createContent(Template template, Map<String, Object> data) throws IOException, TemplateException {
        try (StringWriter out = new StringWriter();){
            template.process(data, (Writer)out);
            String string = ((Object)out).toString();
            return string;
        }
    }

    public static String createTitle(MailNotificationType notificationType) {
        return "[" + Joiner.on((String)"]-[").join((Object)MAIL_TITLE_PREFIX, (Object)notificationType.getDisplayName(), new Object[0]) + "]";
    }

    public static class MailTemplate {
        private static final String MAIL_TEMPLATES_DIR = "/mail_templates";
        private static final Configuration configuration = new Configuration(Configuration.getVersion());

        private MailTemplate() {
            throw new IllegalStateException("Utility class");
        }

        public static Template getTemplate(String templateName) throws IOException {
            return configuration.getTemplate(templateName + ".ftl");
        }

        static {
            configuration.setClassForTemplateLoading(MailTemplate.class, MAIL_TEMPLATES_DIR);
            configuration.setDefaultEncoding(StandardCharsets.UTF_8.toString());
        }
    }
}

