/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.exception.code;

import org.apache.kylin.common.exception.code.ErrorCode;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorMsg;
import org.apache.kylin.common.exception.code.ErrorSuggestion;

public enum ErrorCodeSystem implements ErrorCodeProducer
{
    PASSWORD_INVALID_ENCODER("KE-040005201"),
    PASSWORD_INIT_ENCODER_FAILED("KE-040005202"),
    EPOCH_DOES_NOT_BELONG_TO_CURRENT_NODE("KE-040021201"),
    JOB_NODE_API_INVALID("KE-040023201"),
    JOB_NODE_QUERY_API_INVALID("KE-040023202"),
    QUERY_NODE_API_INVALID("KE-040023203"),
    MAINTENANCE_MODE_WRITE_FAILED("KE-040024201"),
    MAINTENANCE_MODE_ENTER_FAILED("KE-040024202"),
    MAINTENANCE_MODE_LEAVE_FAILED("KE-040024203"),
    SYSTEM_PROFILE_ABNORMAL_DATA("KE-040026201");

    private final ErrorCode errorCode;
    private final ErrorMsg errorMsg;
    private final ErrorSuggestion errorSuggestion;

    private ErrorCodeSystem(String keCode) {
        this.errorCode = new ErrorCode(keCode);
        this.errorMsg = new ErrorMsg(this.errorCode.getCode());
        this.errorSuggestion = new ErrorSuggestion(this.errorCode.getCode());
    }

    @Override
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    public ErrorMsg getErrorMsg() {
        return this.errorMsg;
    }

    @Override
    public ErrorSuggestion getErrorSuggest() {
        return this.errorSuggestion;
    }
}

