/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.exception.code;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.kylin.common.exception.ErrorCodeException;
import org.apache.kylin.common.util.FileUtils;
import org.apache.kylin.common.util.ResourceUtils;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorCode
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErrorCode.class);
    private static final String ERROR_CODE_FILE = "kylin_errorcode_conf.properties";
    private static final ImmutableSet<String> CODE_SET;
    private final String keCode;

    public ErrorCode(String keCode) {
        if (!CODE_SET.contains((Object)keCode)) {
            throw new ErrorCodeException("Error code [" + keCode + "] must be defined in the error code file");
        }
        this.keCode = keCode;
    }

    public String getCode() {
        return this.keCode;
    }

    static {
        try {
            URL resource = ResourceUtils.getServerConfUrl(ERROR_CODE_FILE);
            log.info("loading error code {}", (Object)resource.getPath());
            CODE_SET = ImmutableMap.copyOf(new ConcurrentHashMap<String, String>(FileUtils.readFromPropertiesFile(resource.openStream()))).keySet();
            log.info("loading error code successful");
        }
        catch (IOException e) {
            throw new ErrorCodeException("loading error code failed.", e);
        }
    }
}

