/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.collect.BiMap;
import org.apache.kylin.guava30.shaded.common.collect.HashBiMap;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.HybridRealization;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.query.relnode.OlapContextProp;
import org.apache.kylin.query.routing.Candidate;
import org.apache.kylin.query.routing.DataflowCapabilityChecker;
import org.apache.kylin.query.routing.PruningRule;
import org.apache.kylin.query.routing.RealizationChooser;
import org.apache.kylin.query.util.ComputedColumnRewriter;
import org.apache.kylin.query.util.QueryAliasMatchInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveIncapableRealizationsRule
extends PruningRule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RemoveIncapableRealizationsRule.class);

    @Override
    public void apply(Candidate candidate) {
        if (!this.isStorageMatch(candidate)) {
            return;
        }
        if (candidate.getCapability() != null) {
            return;
        }
        OlapContextProp propsBeforeRewrite = RealizationChooser.preservePropsBeforeRewrite(candidate.getCtx());
        CapabilityResult capabilityResult = new CapabilityResult();
        IRealization realization = candidate.getRealization();
        if (!realization.getModel().getComputedColumnDescs().isEmpty()) {
            HashBiMap aliasMapping = HashBiMap.create(candidate.getMatchedJoinsGraphAliasMap());
            ComputedColumnRewriter.rewriteCcInnerCol(candidate.getCtx(), realization.getModel(), new QueryAliasMatchInfo((BiMap<String, String>)aliasMapping, null));
            candidate.getCtx().resetSQLDigest();
            capabilityResult = this.getCapabilityResult(candidate);
            candidate.recordRewrittenCtxProps();
        }
        if (!capabilityResult.isCapable()) {
            RealizationChooser.restoreOlapContextProps(candidate.getCtx(), propsBeforeRewrite);
            candidate.getCtx().resetSQLDigest();
            capabilityResult = this.getCapabilityResult(candidate);
            candidate.recordRewrittenCtxProps();
        }
        candidate.setCapability(capabilityResult);
    }

    @Override
    public boolean isStorageMatch(Candidate candidate) {
        return candidate.getRealization().getModel().getStorageType().isV1Storage();
    }

    private CapabilityResult getCapabilityResult(Candidate candidate) {
        IRealization realization = candidate.getRealization();
        SQLDigest sqlDigest = candidate.getCtx().getSQLDigest();
        CapabilityResult capability = realization instanceof HybridRealization ? DataflowCapabilityChecker.hybridRealizationCheck((HybridRealization)realization, candidate, sqlDigest) : DataflowCapabilityChecker.check((NDataflow)realization, candidate, sqlDigest);
        candidate.recordRewrittenCtxProps();
        return capability;
    }
}

