/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.routing;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.realization.CapabilityResult;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.QueryableSeg;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapContextProp;
import org.apache.kylin.query.routing.RealizationChooser;

public class Candidate {
    IRealization realization;
    OlapContext ctx;
    CapabilityResult capability;
    OlapContextProp rewrittenCtx;
    Map<String, String> matchedJoinsGraphAliasMap;
    private Map<String, List<Long>> prunedPartitions;
    private final QueryableSeg queryableSeg = new QueryableSeg();

    public List<NDataSegment> getPrunedSegments(NDataflow df) {
        if (df.isStreaming()) {
            return this.queryableSeg.getStreamingSegments();
        }
        return this.queryableSeg.getBatchSegments();
    }

    public void setPrunedSegments(Segments<NDataSegment> prunedSegments, NDataflow df) {
        if (df.isStreaming()) {
            this.queryableSeg.setStreamingSegments(prunedSegments);
        } else {
            this.queryableSeg.setBatchSegments(prunedSegments);
        }
    }

    public Candidate(IRealization realization, OlapContext ctx, Map<String, String> matchedJoinsGraphAliasMap) {
        this.realization = realization;
        this.ctx = ctx;
        this.matchedJoinsGraphAliasMap = matchedJoinsGraphAliasMap;
        this.recordRewrittenCtxProps();
    }

    void recordRewrittenCtxProps() {
        this.rewrittenCtx = RealizationChooser.preservePropsBeforeRewrite(this.ctx);
    }

    public String toString() {
        return this.realization.toString();
    }

    public static Comparator<Candidate> tableIndexUnmatchedColSizeSorter() {
        return Comparator.comparingInt(c -> c.getCapability().getLayoutUnmatchedColsSize());
    }

    public static Comparator<Candidate> modelPrioritySorter() {
        return (c1, c2) -> {
            if (QueryContext.current().getModelPriorities().length == 0) {
                return 0;
            }
            HashMap<String, Integer> priorities = new HashMap<String, Integer>();
            for (int i = 0; i < QueryContext.current().getModelPriorities().length; ++i) {
                priorities.put(QueryContext.current().getModelPriorities()[i], i);
            }
            String modelAlias1 = StringUtils.upperCase((String)c1.getRealization().getModel().getAlias());
            String modelAlias2 = StringUtils.upperCase((String)c2.getRealization().getModel().getAlias());
            return priorities.getOrDefault(modelAlias1, Integer.MAX_VALUE) - priorities.getOrDefault(modelAlias2, Integer.MAX_VALUE);
        };
    }

    public static Comparator<Candidate> realizationCostSorter() {
        return Comparator.comparingInt(c -> c.getRealization().getCost());
    }

    public static Comparator<Candidate> partialResultSorter() {
        return Comparator.comparing(c -> c.getCapability().isPartialResult());
    }

    public static Comparator<Candidate> realizationCapabilityCostSorter() {
        return Comparator.comparingDouble(c -> {
            boolean isPartialCompare = c.getCapability().isPartialResult();
            return isPartialCompare ? -1.0 * c.getCapability().getCost() : c.getCapability().getCost();
        });
    }

    public static Comparator<Candidate> modelUuidSorter() {
        return Comparator.comparing(c -> c.getRealization().getModel().getId());
    }

    @Generated
    public IRealization getRealization() {
        return this.realization;
    }

    @Generated
    public OlapContext getCtx() {
        return this.ctx;
    }

    @Generated
    public CapabilityResult getCapability() {
        return this.capability;
    }

    @Generated
    public OlapContextProp getRewrittenCtx() {
        return this.rewrittenCtx;
    }

    @Generated
    public Map<String, String> getMatchedJoinsGraphAliasMap() {
        return this.matchedJoinsGraphAliasMap;
    }

    @Generated
    public Map<String, List<Long>> getPrunedPartitions() {
        return this.prunedPartitions;
    }

    @Generated
    public QueryableSeg getQueryableSeg() {
        return this.queryableSeg;
    }

    @Generated
    public void setCapability(CapabilityResult capability) {
        this.capability = capability;
    }

    @Generated
    public void setRewrittenCtx(OlapContextProp rewrittenCtx) {
        this.rewrittenCtx = rewrittenCtx;
    }

    @Generated
    public void setMatchedJoinsGraphAliasMap(Map<String, String> matchedJoinsGraphAliasMap) {
        this.matchedJoinsGraphAliasMap = matchedJoinsGraphAliasMap;
    }

    @Generated
    public void setPrunedPartitions(Map<String, List<Long>> prunedPartitions) {
        this.prunedPartitions = prunedPartitions;
    }
}

