/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.relnode;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.query.relnode.ColumnRowType;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.OlapContext;
import org.apache.kylin.query.relnode.OlapRel;
import org.apache.kylin.query.util.ICutContextStrategy;

public class OlapMinusRel
extends Minus
implements OlapRel {
    protected ColumnRowType columnRowType;
    protected OlapContext context;
    private Set<OlapContext> subContexts = Sets.newHashSet();

    public OlapMinusRel(RelOptCluster cluster, RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
        super(cluster, traitSet, inputs, all);
        this.rowType = this.getRowType();
    }

    @Override
    public EnumerableRel implementEnumerable(List<EnumerableRel> inputs) {
        throw new RuntimeException("Not Implemented");
    }

    @Override
    public void implementCutContext(ICutContextStrategy.ContextCutImpl contextCutImpl) {
        throw new RuntimeException("Minus rel should not be re-cut from outside");
    }

    public SetOp copy(RelTraitSet traitSet, List<RelNode> inputs, boolean all) {
        return new OlapMinusRel(this.getCluster(), traitSet, inputs, all);
    }

    @Override
    public boolean pushRelInfoToContext(OlapContext context) {
        return context == this.context;
    }

    @Override
    public void implementContext(OlapRel.ContextImpl contextImpl, OlapRel.ContextVisitorState state) {
        OlapRel.ContextVisitorState accumulateState = OlapRel.ContextVisitorState.init();
        for (int i = 0; i < this.getInputs().size(); ++i) {
            contextImpl.fixSharedOlapTableScanAt(this, i);
            OlapRel.ContextVisitorState tempState = OlapRel.ContextVisitorState.init();
            RelNode input = this.getInput(i);
            contextImpl.visitChild(input, this, tempState);
            if (tempState.hasFreeTable()) {
                contextImpl.allocateContext((OlapRel)input, this);
            }
            tempState.setHasFreeTable(false);
            accumulateState.merge(tempState);
        }
        state.merge(accumulateState);
        for (RelNode subRel : this.getInputs()) {
            this.subContexts.addAll(ContextUtil.collectSubContext(subRel));
        }
    }

    protected ColumnRowType buildColumnRowType() {
        ColumnRowType inputColumnRowType = ((OlapRel)this.getInput(0)).getColumnRowType();
        ArrayList<TblColRef> columns = new ArrayList<TblColRef>();
        for (TblColRef tblColRef : inputColumnRowType.getAllColumns()) {
            columns.add(TblColRef.newInnerColumn((String)tblColRef.getName(), (TblColRef.InnerDataTypeEnum)TblColRef.InnerDataTypeEnum.LITERAL));
        }
        return new ColumnRowType(columns, inputColumnRowType.getSourceColumns());
    }

    @Override
    public void implementOlap(OlapRel.OlapImpl olapImpl) {
        for (RelNode input : this.getInputs()) {
            olapImpl.visitChild(input, this);
        }
        this.columnRowType = this.buildColumnRowType();
        if (this.context != null && this == this.context.getTopNode() && !this.context.isHasAgg()) {
            ContextUtil.amendAllColsIfNoAgg(this);
        }
    }

    @Override
    public void implementRewrite(OlapRel.RewriteImpl rewriteImpl) {
        for (RelNode child : this.getInputs()) {
            rewriteImpl.visitChild(this, child);
        }
        if (this.context != null) {
            this.rowType = this.deriveRowType();
        }
    }

    @Override
    public void setContext(OlapContext context) {
        throw new RuntimeException("Minus rel should not be set context from outside");
    }

    @Override
    public boolean hasSubQuery() {
        for (RelNode child : this.getInputs()) {
            if (!((OlapRel)child).hasSubQuery()) continue;
            return true;
        }
        return false;
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    @Override
    public RelTraitSet replaceTraitSet(RelTrait trait) {
        RelTraitSet oldTraitSet = this.traitSet;
        this.traitSet = this.traitSet.replace(trait);
        return oldTraitSet;
    }

    @Override
    @Generated
    public ColumnRowType getColumnRowType() {
        return this.columnRowType;
    }

    @Override
    @Generated
    public OlapContext getContext() {
        return this.context;
    }

    @Override
    @Generated
    public Set<OlapContext> getSubContexts() {
        return this.subContexts;
    }

    @Override
    @Generated
    public void setSubContexts(Set<OlapContext> subContexts) {
        this.subContexts = subContexts;
    }
}

