/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.calcite;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlSplittableAggFunction;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Optionality;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.query.calcite.KylinRelDataTypeSystem;
import org.apache.kylin.query.calcite.KylinSumSplitter;
import org.checkerframework.checker.nullness.qual.Nullable;

public class KylinSqlSumAggFunction
extends SqlAggFunction {
    public static final SqlReturnTypeInference NON_WIDEN_AGG_SUM = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType returnType = opBinding.getOperandType(0);
        boolean isImprovedSumDecimalPrecisionEnabled = KylinRelDataTypeSystem.getProjectConfig().isImprovedSumDecimalPrecisionEnabled();
        if (!SqlTypeUtil.isDecimal((RelDataType)returnType) || !isImprovedSumDecimalPrecisionEnabled) {
            returnType = typeFactory.getTypeSystem().deriveSumType(typeFactory, returnType);
        }
        if (opBinding.getGroupCount() == 0 || opBinding.hasFilter()) {
            return typeFactory.createTypeWithNullability(returnType, true);
        }
        return returnType;
    };
    @Deprecated
    private final RelDataType type;

    public KylinSqlSumAggFunction(RelDataType type) {
        super("SUM", null, SqlKind.SUM, NON_WIDEN_AGG_SUM, null, (SqlOperandTypeChecker)OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC, false, false, Optionality.FORBIDDEN);
        this.type = type;
    }

    public List<RelDataType> getParameterTypes(RelDataTypeFactory typeFactory) {
        return ImmutableList.of((Object)this.type);
    }

    @Deprecated
    public RelDataType getType() {
        return this.type;
    }

    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return this.type;
    }

    public <T> @Nullable T unwrap(Class<T> clazz) {
        if (clazz == SqlSplittableAggFunction.class) {
            return clazz.cast((Object)KylinSumSplitter.INSTANCE);
        }
        return (T)super.unwrap(clazz);
    }

    public SqlAggFunction getRollup() {
        return this;
    }
}

