/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.substrait.rel;

import io.substrait.proto.ReadRel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.gluten.config.GlutenConfig;
import org.apache.gluten.substrait.rel.LocalFilesNode;
import org.apache.iceberg.DeleteFile;

public class IcebergLocalFilesNode
extends LocalFilesNode {
    private final List<List<DeleteFile>> deleteFilesList;

    IcebergLocalFilesNode(Integer index, List<String> paths, List<Long> starts, List<Long> lengths, List<Map<String, String>> partitionColumns, LocalFilesNode.ReadFileFormat fileFormat, List<String> preferredLocations, List<List<DeleteFile>> deleteFilesList) {
        super(index, paths, starts, lengths, new ArrayList(), new ArrayList(), partitionColumns, new ArrayList(), fileFormat, preferredLocations, new HashMap());
        this.deleteFilesList = deleteFilesList;
    }

    protected void processFileBuilder(ReadRel.LocalFiles.FileOrFiles.Builder fileBuilder, int index) {
        List<DeleteFile> deleteFiles = this.deleteFilesList.get(index);
        ReadRel.LocalFiles.FileOrFiles.IcebergReadOptions.Builder icebergBuilder = ReadRel.LocalFiles.FileOrFiles.IcebergReadOptions.newBuilder();
        switch (this.fileFormat) {
            case ParquetReadFormat: {
                ReadRel.LocalFiles.FileOrFiles.ParquetReadOptions parquetReadOptions = ReadRel.LocalFiles.FileOrFiles.ParquetReadOptions.newBuilder().setEnableRowGroupMaxminIndex(GlutenConfig.get().enableParquetRowGroupMaxMinIndex()).build();
                icebergBuilder.setParquet(parquetReadOptions);
                break;
            }
            case OrcReadFormat: {
                ReadRel.LocalFiles.FileOrFiles.OrcReadOptions orcReadOptions = ReadRel.LocalFiles.FileOrFiles.OrcReadOptions.newBuilder().build();
                icebergBuilder.setOrc(orcReadOptions);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported file format " + this.fileFormat.name() + " for iceberg data file.");
            }
        }
        for (DeleteFile delete : deleteFiles) {
            ReadRel.LocalFiles.FileOrFiles.IcebergReadOptions.FileContent fileContent;
            ReadRel.LocalFiles.FileOrFiles.IcebergReadOptions.DeleteFile.Builder deleteFileBuilder = ReadRel.LocalFiles.FileOrFiles.IcebergReadOptions.DeleteFile.newBuilder();
            switch (delete.content()) {
                case EQUALITY_DELETES: {
                    fileContent = ReadRel.LocalFiles.FileOrFiles.IcebergReadOptions.FileContent.EQUALITY_DELETES;
                    break;
                }
                case POSITION_DELETES: {
                    fileContent = ReadRel.LocalFiles.FileOrFiles.IcebergReadOptions.FileContent.POSITION_DELETES;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported FileCount " + delete.content().name() + " for delete file.");
                }
            }
            deleteFileBuilder.setFileContent(fileContent);
            deleteFileBuilder.setFilePath(delete.path().toString());
            deleteFileBuilder.setFileSize(delete.fileSizeInBytes());
            deleteFileBuilder.setRecordCount(delete.recordCount());
            switch (delete.format()) {
                case PARQUET: {
                    ReadRel.LocalFiles.FileOrFiles.ParquetReadOptions parquetReadOptions = ReadRel.LocalFiles.FileOrFiles.ParquetReadOptions.newBuilder().setEnableRowGroupMaxminIndex(GlutenConfig.get().enableParquetRowGroupMaxMinIndex()).build();
                    deleteFileBuilder.setParquet(parquetReadOptions);
                    break;
                }
                case ORC: {
                    ReadRel.LocalFiles.FileOrFiles.OrcReadOptions orcReadOptions = ReadRel.LocalFiles.FileOrFiles.OrcReadOptions.newBuilder().build();
                    deleteFileBuilder.setOrc(orcReadOptions);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported format " + delete.format().name() + " for delete file.");
                }
            }
            icebergBuilder.addDeleteFiles(deleteFileBuilder);
        }
        fileBuilder.setIceberg(icebergBuilder);
    }
}

