/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.DDLRequest;
import org.apache.kylin.rest.request.ExportTableRequest;
import org.apache.kylin.rest.response.DDLResponse;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.ExportTablesResponse;
import org.apache.kylin.rest.response.TableNameResponse;
import org.apache.kylin.rest.service.SparkSourceService;
import org.apache.spark.sql.AnalysisException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnProperty(name={"kylin.env.channel"}, havingValue="cloud")
@RestController
@RequestMapping(value={"/api/spark_source"}, produces={"application/vnd.apache.kylin-v4-public+json", "application/vnd.apache.kylin-v4+json"})
public class SparkSourceController
extends NBasicController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SparkSourceController.class);
    @Autowired
    private SparkSourceService sparkSourceService;

    @ApiOperation(value="execute", tags={"DW"})
    @PostMapping(value={"/execute"})
    @ResponseBody
    public EnvelopeResponse<DDLResponse> executeSQL(@RequestBody DDLRequest request) {
        DDLResponse ddlResponse = this.sparkSourceService.executeSQL(request);
        return new EnvelopeResponse("000", (Object)ddlResponse, "");
    }

    @ApiOperation(value="exportTable", tags={"DW"})
    @PostMapping(value={"/export_table_structure"})
    @ResponseBody
    public EnvelopeResponse<ExportTablesResponse> exportTableStructure(@RequestBody ExportTableRequest request) {
        ExportTablesResponse tableResponse = this.sparkSourceService.exportTables(request.getDatabases(), request.getTables());
        return new EnvelopeResponse("000", (Object)tableResponse, "");
    }

    @ApiOperation(value="dropTable", tags={"DW"})
    @DeleteMapping(value={"/{database}/tables/{table}"})
    public EnvelopeResponse<String> dropTable(@PathVariable(value="database") String database, @PathVariable(value="table") String table) throws AnalysisException {
        this.sparkSourceService.dropTable(database, table);
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @ApiOperation(value="listDatabase", tags={"DW"})
    @GetMapping(value={"/databases"})
    public EnvelopeResponse<List<String>> listDatabase() {
        return new EnvelopeResponse("000", (Object)this.sparkSourceService.listDatabase(), "");
    }

    @ApiOperation(value="listTables", tags={"DW"})
    @GetMapping(value={"/{database}/tables"})
    public EnvelopeResponse<List<TableNameResponse>> listTables(@PathVariable(value="database") String database, @RequestParam(value="project") String project) throws Exception {
        return new EnvelopeResponse("000", (Object)this.sparkSourceService.listTables(database, project), "");
    }

    @ApiOperation(value="listColumns", tags={"DW"})
    @GetMapping(value={"/{database}/{table}/columns"})
    public EnvelopeResponse<List<SparkSourceService.ColumnModel>> listColumns(@PathVariable(value="database") String database, @PathVariable(value="table") String table) {
        return new EnvelopeResponse("000", (Object)this.sparkSourceService.listColumns(database, table), "");
    }

    @ApiOperation(value="getTableDesc", tags={"DW"})
    @GetMapping(value={"/{database}/{table}/desc"})
    public EnvelopeResponse<String> getTableDesc(@PathVariable(value="database") String database, @PathVariable(value="table") String table) {
        return new EnvelopeResponse("000", (Object)this.sparkSourceService.getTableDesc(database, table), "");
    }

    @ApiOperation(value="hasPartition", tags={"DW"})
    @GetMapping(value={"{database}/{table}/has_partition"})
    public EnvelopeResponse<Boolean> hasPartition(@PathVariable(value="database") String database, @PathVariable(value="table") String table) {
        return new EnvelopeResponse("000", (Object)this.sparkSourceService.hasPartition(database, table), "");
    }

    @ApiOperation(value="databaseExists", tags={"DW"})
    @GetMapping(value={"/{database}/exists"})
    public EnvelopeResponse<Boolean> databaseExists(@PathVariable(value="database") String database) {
        return new EnvelopeResponse("000", (Object)this.sparkSourceService.databaseExists(database), "");
    }

    @ApiOperation(value="tableExists", tags={"DW"})
    @GetMapping(value={"/{database}/{table}/exists"})
    public EnvelopeResponse<Boolean> tableExists(@PathVariable(value="database") String database, @PathVariable(value="table") String table) {
        return new EnvelopeResponse("000", (Object)this.sparkSourceService.tableExists(database, table), "");
    }

    @ApiOperation(value="loadSamples", tags={"DW"})
    @GetMapping(value={"/load_samples"})
    public EnvelopeResponse<List<String>> loadSamples() throws InterruptedException, IOException {
        return new EnvelopeResponse("000", (Object)this.sparkSourceService.loadSamples(), "");
    }

    @ApiOperation(value="msck", tags={"DW"})
    @GetMapping(value={"/{database}/{table}/msck"})
    public EnvelopeResponse<List<String>> msck(@PathVariable(value="database") String database, @PathVariable(value="table") String table) {
        return new EnvelopeResponse("000", (Object)this.sparkSourceService.msck(database, table), "");
    }
}

