/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.udaf;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.Set;
import org.apache.kylin.common.util.ByteBufferOutputStream;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.common.SparderBaseFunSuite;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.udaf.IntersectBitmapCounter;
import org.apache.spark.sql.udaf.IntersectCount;
import org.apache.spark.sql.udaf.IntersectCount$;
import org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Outcome;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.TestSuite;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00113A!\u0002\u0004\u0001#!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001b\u0001\n\u0013)\u0003B\u0002\u0018\u0001A\u0003%a\u0005C\u00030\u0001\u0011%\u0001GA\nJ]R,'o]3di\u000e{WO\u001c;Tk&$XM\u0003\u0002\b\u0011\u0005!Q\u000fZ1g\u0015\tI!\"A\u0002tc2T!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\r\u0001!C\u0007\t\u0003'ai\u0011\u0001\u0006\u0006\u0003+Y\t\u0001BZ;ogVLG/\u001a\u0006\u0003/9\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005e!\"aC!os\u001a+hnU;ji\u0016\u0004\"a\u0007\u0010\u000e\u0003qQ!!\b\u0005\u0002\r\r|W.\\8o\u0013\tyBDA\nTa\u0006\u0014H-\u001a:CCN,g)\u001e8Tk&$X-\u0001\u0004=S:LGO\u0010\u000b\u0002EA\u00111\u0005A\u0007\u0002\r\u0005Q!-\u001f;f\u0005V4g-\u001a:\u0016\u0003\u0019\u0002\"a\n\u0017\u000e\u0003!R!!\u000b\u0016\u0002\u00079LwNC\u0001,\u0003\u0011Q\u0017M^1\n\u00055B#A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006Y!-\u001f;f\u0005V4g-\u001a:!\u0003%\u0019XM]5bY&TX\r\u0006\u00022uA\u0019!'N\u001c\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012Q!\u0011:sCf\u0004\"A\r\u001d\n\u0005e\u001a$\u0001\u0002\"zi\u0016DQa\u000f\u0003A\u0002q\naAY5u[\u0006\u0004\bCA\u001fC\u001b\u0005q$BA A\u0003!awN\\4m_:<'BA!\u000f\u00035\u0011x.\u0019:j]\u001e\u0014\u0017\u000e^7ba&\u00111I\u0010\u0002\u0016%>\f'/\u001b8hmQr\u0015M^5hC\ndW-T1q\u0001")
public class IntersectCountSuite
extends AnyFunSuite
implements SparderBaseFunSuite {
    private final ByteBuffer byteBuffer;
    private final boolean enableAutoThreadAudit;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private String sparkHome;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$sql$common$SparderBaseFunSuite$$super$beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$common$SparderBaseFunSuite$$super$afterAll() {
        BeforeAndAfterAll.afterAll$((BeforeAndAfterAll)this);
    }

    @Override
    public void beforeAll() {
        SparderBaseFunSuite.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        SparderBaseFunSuite.afterAll$(this);
    }

    @Override
    public final File getTestResourceFile(String file) {
        return SparderBaseFunSuite.getTestResourceFile$(this, file);
    }

    @Override
    public final String getTestResourcePath(String file) {
        return SparderBaseFunSuite.getTestResourcePath$(this, file);
    }

    @Override
    public final File copyAndGetResourceFile(String fileName, String suffix) {
        return SparderBaseFunSuite.copyAndGetResourceFile$(this, fileName, suffix);
    }

    @Override
    public void testRetry(String s, int n, Function0<BoxedUnit> body) {
        SparderBaseFunSuite.testRetry$(this, s, n, body);
    }

    @Override
    public int testRetry$default$2() {
        return SparderBaseFunSuite.testRetry$default$2$(this);
    }

    @Override
    public <T> T retry(int n, Function0<T> body) {
        return (T)SparderBaseFunSuite.retry$(this, n, body);
    }

    @Override
    public final Outcome withFixture(TestSuite.NoArgTest test) {
        return SparderBaseFunSuite.withFixture$(this, test);
    }

    @Override
    public void withTempDir(Function1<File, BoxedUnit> f) {
        SparderBaseFunSuite.withTempDir$(this, f);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public void afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return AnyFunSuiteLike.run$((AnyFunSuiteLike)this, (Option)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$common$SparderBaseFunSuite$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String sparkHome$lzycompute() {
        IntersectCountSuite intersectCountSuite = this;
        synchronized (intersectCountSuite) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        return !this.bitmap$0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    private ByteBuffer byteBuffer() {
        return this.byteBuffer;
    }

    private byte[] serialize(Roaring64NavigableMap bitmap) {
        this.byteBuffer().clear();
        DataOutputStream dos = new DataOutputStream((OutputStream)new ByteBufferOutputStream(this.byteBuffer()));
        bitmap.serialize((DataOutput)dos);
        dos.close();
        return (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.byteBuffer().array())).slice(0, this.byteBuffer().position());
    }

    public IntersectCountSuite() {
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        SQLHelper.$init$((SQLHelper)this);
        Logging.$init$((Logging)this);
        SparderBaseFunSuite.$init$(this);
        this.byteBuffer = ByteBuffer.allocate(1024);
        this.test("return correct result when process row in happy path", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoundReference child1 = new BoundReference(0, (DataType)BinaryType$.MODULE$, true);
            BoundReference child2 = new BoundReference(1, (DataType)DateType$.MODULE$, true);
            Literal child3 = Literal$.MODULE$.apply((Object)new int[]{1, 2});
            IntersectCount count = new IntersectCount((Expression)child1, (Expression)child2, (Expression)child3, (Expression)Literal$.MODULE$.apply((Object)IntersectCount$.MODULE$.RAW_STRING()), (DataType)LongType$.MODULE$, "\\|", IntersectCount$.MODULE$.apply$default$7(), IntersectCount$.MODULE$.apply$default$8(), IntersectCount$.MODULE$.apply$default$9());
            IntersectBitmapCounter buffer = count.createAggregationBuffer();
            GenericInternalRow row = new GenericInternalRow(2);
            row.update(0, null);
            row.update(1, (Object)BoxesRunTime.boxToInteger((int)1));
            count.update(buffer, (InternalRow)row);
            Roaring64NavigableMap bitmap1 = new Roaring64NavigableMap();
            bitmap1.add(new long[]{1L, 3L, 5L, 7L, 9L});
            row.update(0, (Object)this.serialize(bitmap1));
            row.update(1, (Object)BoxesRunTime.boxToInteger((int)1));
            count.update(buffer, (InternalRow)row);
            Roaring64NavigableMap bitmap2 = new Roaring64NavigableMap();
            bitmap2.add(new long[]{2L, 4L, 5L, 7L, 9L});
            row.update(0, (Object)this.serialize(bitmap2));
            row.update(1, (Object)BoxesRunTime.boxToInteger((int)2));
            count.update(buffer, (InternalRow)row);
            Roaring64NavigableMap bitmap3 = new Roaring64NavigableMap();
            bitmap3.add(new long[]{1L, 3L, 6L, 8L, 10L});
            row.update(0, (Object)this.serialize(bitmap3));
            row.update(1, (Object)BoxesRunTime.boxToInteger((int)3));
            count.update(buffer, (InternalRow)row);
            Roaring64NavigableMap bitmap4 = new Roaring64NavigableMap();
            bitmap4.add(new long[]{1L, 3L, 5L, 7L, 9L});
            row.update(0, (Object)this.serialize(bitmap4));
            row.update(1, null);
            count.update(buffer, (InternalRow)row);
            Roaring64NavigableMap bitmap5 = new Roaring64NavigableMap();
            bitmap5.add(new long[]{4L});
            IntersectBitmapCounter otherBuffer = new IntersectBitmapCounter();
            otherBuffer.map().put("1", bitmap5);
            count.merge(buffer, otherBuffer);
            Object $org_scalatest_assert_macro_left = count.eval(buffer);
            long $org_scalatest_assert_macro_right = 4L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntersectCountSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        }, new Position("IntersectCountSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("return 0 when array size is 0", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoundReference child1 = new BoundReference(0, (DataType)BinaryType$.MODULE$, true);
            BoundReference child2 = new BoundReference(1, (DataType)DateType$.MODULE$, true);
            Literal child3 = Literal$.MODULE$.apply(Array$.MODULE$.empty(ClassTag$.MODULE$.Int()));
            IntersectCount count = new IntersectCount((Expression)child1, (Expression)child2, (Expression)child3, (Expression)Literal$.MODULE$.apply((Object)IntersectCount$.MODULE$.RAW_STRING()), (DataType)LongType$.MODULE$, "\\|", IntersectCount$.MODULE$.apply$default$7(), IntersectCount$.MODULE$.apply$default$8(), IntersectCount$.MODULE$.apply$default$9());
            IntersectBitmapCounter buffer = count.createAggregationBuffer();
            GenericInternalRow row = new GenericInternalRow(2);
            Roaring64NavigableMap bitmap1 = new Roaring64NavigableMap();
            bitmap1.add(new long[]{1L, 3L, 5L, 7L, 9L});
            row.update(0, (Object)this.serialize(bitmap1));
            row.update(1, (Object)BoxesRunTime.boxToInteger((int)1));
            count.update(buffer, (InternalRow)row);
            count.update(buffer, (InternalRow)row);
            Object $org_scalatest_assert_macro_left = count.eval(buffer);
            long $org_scalatest_assert_macro_right = 0L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntersectCountSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        }, new Position("IntersectCountSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("return 0 when map size is not equal to array size", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoundReference child1 = new BoundReference(0, (DataType)BinaryType$.MODULE$, true);
            BoundReference child2 = new BoundReference(1, (DataType)DateType$.MODULE$, true);
            Literal child3 = Literal$.MODULE$.apply((Object)new int[]{1, 2});
            IntersectCount count = new IntersectCount((Expression)child1, (Expression)child2, (Expression)child3, (Expression)Literal$.MODULE$.apply((Object)IntersectCount$.MODULE$.RAW_STRING()), (DataType)LongType$.MODULE$, "\\|", IntersectCount$.MODULE$.apply$default$7(), IntersectCount$.MODULE$.apply$default$8(), IntersectCount$.MODULE$.apply$default$9());
            IntersectBitmapCounter buffer = count.createAggregationBuffer();
            GenericInternalRow row = new GenericInternalRow(2);
            Roaring64NavigableMap bitmap1 = new Roaring64NavigableMap();
            bitmap1.add(new long[]{1L, 3L, 5L, 7L, 9L});
            row.update(0, (Object)this.serialize(bitmap1));
            row.update(1, (Object)BoxesRunTime.boxToInteger((int)1));
            count.update(buffer, (InternalRow)row);
            count.update(buffer, (InternalRow)row);
            Roaring64NavigableMap bitmap2 = new Roaring64NavigableMap();
            bitmap2.add(new long[]{2L, 4L, 6L, 8L, 10L});
            row.update(0, (Object)this.serialize(bitmap2));
            row.update(1, (Object)BoxesRunTime.boxToInteger((int)1));
            count.update(buffer, (InternalRow)row);
            count.update(buffer, (InternalRow)row);
            Object $org_scalatest_assert_macro_left = count.eval(buffer);
            long $org_scalatest_assert_macro_right = 0L;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left, (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntersectCountSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        }, new Position("IntersectCountSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("serialize and deserialize counter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoundReference child1 = new BoundReference(0, (DataType)BinaryType$.MODULE$, true);
            BoundReference child2 = new BoundReference(1, (DataType)DateType$.MODULE$, true);
            Literal child3 = Literal$.MODULE$.apply((Object)new int[]{1, 2});
            IntersectCount count = new IntersectCount((Expression)child1, (Expression)child2, (Expression)child3, (Expression)Literal$.MODULE$.apply((Object)IntersectCount$.MODULE$.RAW_STRING()), (DataType)LongType$.MODULE$, "\\|", IntersectCount$.MODULE$.apply$default$7(), IntersectCount$.MODULE$.apply$default$8(), IntersectCount$.MODULE$.apply$default$9());
            IntersectBitmapCounter counter = new IntersectBitmapCounter();
            Roaring64NavigableMap map1 = new Roaring64NavigableMap();
            map1.add(new long[]{1L, 3L, 5L, 7L, 9L});
            counter.map().put("1", map1);
            Roaring64NavigableMap map2 = new Roaring64NavigableMap();
            map2.add(new long[]{2L, 4L, 6L, 8L, 10L});
            counter.map().put("2", map2);
            byte[] bytes = count.serialize(counter);
            IntersectBitmapCounter deCounter = count.deserialize(bytes);
            Set $org_scalatest_assert_macro_left = deCounter.map().keySet();
            Set $org_scalatest_assert_macro_right = counter.map().keySet();
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, !(set != null ? !((Object)set).equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("IntersectCountSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(deCounter.map().values()).asScala()).sameElements((GenIterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(counter.map().values()).asScala()), "scala.collection.JavaConverters.collectionAsScalaIterableConverter[org.roaringbitmap.longlong.Roaring64NavigableMap](deCounter.map().values()).asScala.sameElements[org.roaringbitmap.longlong.Roaring64NavigableMap](scala.collection.JavaConverters.collectionAsScalaIterableConverter[org.roaringbitmap.longlong.Roaring64NavigableMap](counter.map().values()).asScala)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("IntersectCountSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        }, new Position("IntersectCountSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
    }
}

