/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.update.render;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.common.OrderByModel;
import org.mybatis.dynamic.sql.common.OrderByRenderer;
import org.mybatis.dynamic.sql.exception.InvalidSqlException;
import org.mybatis.dynamic.sql.render.ExplicitTableAliasCalculator;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.update.UpdateModel;
import org.mybatis.dynamic.sql.update.render.DefaultUpdateStatementProvider;
import org.mybatis.dynamic.sql.update.render.SetPhraseVisitor;
import org.mybatis.dynamic.sql.update.render.UpdateStatementProvider;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;
import org.mybatis.dynamic.sql.util.Messages;
import org.mybatis.dynamic.sql.where.WhereModel;
import org.mybatis.dynamic.sql.where.render.WhereRenderer;

public class UpdateRenderer {
    private final UpdateModel updateModel;
    private final RenderingStrategy renderingStrategy;
    private final AtomicInteger sequence = new AtomicInteger(1);
    private final TableAliasCalculator tableAliasCalculator;

    private UpdateRenderer(Builder builder) {
        this.updateModel = Objects.requireNonNull(builder.updateModel);
        this.renderingStrategy = Objects.requireNonNull(builder.renderingStrategy);
        this.tableAliasCalculator = builder.updateModel.tableAlias().map(a -> ExplicitTableAliasCalculator.of(this.updateModel.table(), a)).orElseGet(TableAliasCalculator::empty);
    }

    public UpdateStatementProvider render() {
        FragmentCollector fragmentCollector = new FragmentCollector();
        fragmentCollector.add(this.calculateUpdateStatementStart());
        fragmentCollector.add(this.calculateSetPhrase());
        this.calculateWhereClause().ifPresent(fragmentCollector::add);
        this.calculateOrderByClause().ifPresent(fragmentCollector::add);
        this.calculateLimitClause().ifPresent(fragmentCollector::add);
        return this.toUpdateStatementProvider(fragmentCollector);
    }

    private UpdateStatementProvider toUpdateStatementProvider(FragmentCollector fragmentCollector) {
        return DefaultUpdateStatementProvider.withUpdateStatement(fragmentCollector.fragments().collect(Collectors.joining(" "))).withParameters(fragmentCollector.parameters()).build();
    }

    private FragmentAndParameters calculateUpdateStatementStart() {
        SqlTable table = this.updateModel.table();
        String tableName = table.tableNameAtRuntime();
        String aliasedTableName = this.tableAliasCalculator.aliasForTable(table).map(a -> tableName + " " + a).orElse(tableName);
        return FragmentAndParameters.withFragment("update " + aliasedTableName).build();
    }

    private FragmentAndParameters calculateSetPhrase() {
        SetPhraseVisitor visitor = new SetPhraseVisitor(this.sequence, this.renderingStrategy, this.tableAliasCalculator);
        List fragmentsAndParameters = this.updateModel.mapColumnMappings(m -> m.accept(visitor)).collect(Collectors.toList());
        if (fragmentsAndParameters.stream().noneMatch(Optional::isPresent)) {
            throw new InvalidSqlException(Messages.getString("ERROR.18"));
        }
        FragmentCollector fragmentCollector = fragmentsAndParameters.stream().filter(Optional::isPresent).map(Optional::get).collect(FragmentCollector.collect());
        return this.toSetPhrase(fragmentCollector);
    }

    private FragmentAndParameters toSetPhrase(FragmentCollector fragmentCollector) {
        return FragmentAndParameters.withFragment(fragmentCollector.fragments().collect(Collectors.joining(", ", "set ", ""))).withParameters(fragmentCollector.parameters()).build();
    }

    private Optional<FragmentAndParameters> calculateWhereClause() {
        return this.updateModel.whereModel().flatMap(this::renderWhereClause);
    }

    private Optional<FragmentAndParameters> renderWhereClause(WhereModel whereModel) {
        return ((WhereRenderer.Builder)((WhereRenderer.Builder)((WhereRenderer.Builder)WhereRenderer.withWhereModel(whereModel).withRenderingStrategy(this.renderingStrategy)).withSequence(this.sequence)).withTableAliasCalculator(this.tableAliasCalculator)).build().render();
    }

    private Optional<FragmentAndParameters> calculateLimitClause() {
        return this.updateModel.limit().map(this::renderLimitClause);
    }

    private FragmentAndParameters renderLimitClause(Long limit) {
        String mapKey = this.renderingStrategy.formatParameterMapKey(this.sequence);
        String jdbcPlaceholder = this.renderingStrategy.getFormattedJdbcPlaceholder("parameters", mapKey);
        return FragmentAndParameters.withFragment("limit " + jdbcPlaceholder).withParameter(mapKey, limit).build();
    }

    private Optional<FragmentAndParameters> calculateOrderByClause() {
        return this.updateModel.orderByModel().map(this::renderOrderByClause);
    }

    private FragmentAndParameters renderOrderByClause(OrderByModel orderByModel) {
        return new OrderByRenderer().render(orderByModel);
    }

    public static Builder withUpdateModel(UpdateModel updateModel) {
        return new Builder().withUpdateModel(updateModel);
    }

    public static class Builder {
        private UpdateModel updateModel;
        private RenderingStrategy renderingStrategy;

        public Builder withUpdateModel(UpdateModel updateModel) {
            this.updateModel = updateModel;
            return this;
        }

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public UpdateRenderer build() {
            return new UpdateRenderer(this);
        }
    }
}

