/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.common.OrderByModel;
import org.mybatis.dynamic.sql.common.OrderByRenderer;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.select.MultiSelectModel;
import org.mybatis.dynamic.sql.select.PagingModel;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.UnionQuery;
import org.mybatis.dynamic.sql.select.render.DefaultSelectStatementProvider;
import org.mybatis.dynamic.sql.select.render.PagingModelRenderer;
import org.mybatis.dynamic.sql.select.render.SelectRenderer;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;

public class MultiSelectRenderer {
    private final RenderingStrategy renderingStrategy;
    private final AtomicInteger sequence = new AtomicInteger(1);
    private final MultiSelectModel multiSelectModel;

    private MultiSelectRenderer(Builder builder) {
        this.renderingStrategy = Objects.requireNonNull(builder.renderingStrategy);
        this.multiSelectModel = Objects.requireNonNull(builder.multiSelectModel);
    }

    public SelectStatementProvider render() {
        FragmentAndParameters initialSelect = this.renderSelect(this.multiSelectModel.initialSelect());
        FragmentCollector fragmentCollector = this.multiSelectModel.mapUnionQueries(this::renderSelect).collect(FragmentCollector.collect(initialSelect));
        this.renderOrderBy().ifPresent(fragmentCollector::add);
        this.renderPagingModel().ifPresent(fragmentCollector::add);
        return this.toSelectStatementProvider(fragmentCollector);
    }

    private SelectStatementProvider toSelectStatementProvider(FragmentCollector fragmentCollector) {
        return DefaultSelectStatementProvider.withSelectStatement(fragmentCollector.fragments().collect(Collectors.joining(" "))).withParameters(fragmentCollector.parameters()).build();
    }

    private FragmentAndParameters renderSelect(SelectModel selectModel) {
        SelectStatementProvider selectStatement = ((SelectRenderer.Builder)((SelectRenderer.Builder)SelectRenderer.withSelectModel(selectModel).withRenderingStrategy(this.renderingStrategy)).withSequence(this.sequence)).build().render();
        return FragmentAndParameters.withFragment("(" + selectStatement.getSelectStatement() + ")").withParameters(selectStatement.getParameters()).build();
    }

    private FragmentAndParameters renderSelect(UnionQuery unionQuery) {
        SelectStatementProvider selectStatement = ((SelectRenderer.Builder)((SelectRenderer.Builder)SelectRenderer.withSelectModel(unionQuery.selectModel()).withRenderingStrategy(this.renderingStrategy)).withSequence(this.sequence)).build().render();
        return FragmentAndParameters.withFragment(unionQuery.connector() + " (" + selectStatement.getSelectStatement() + ")").withParameters(selectStatement.getParameters()).build();
    }

    private Optional<FragmentAndParameters> renderOrderBy() {
        return this.multiSelectModel.orderByModel().map(this::renderOrderBy);
    }

    private FragmentAndParameters renderOrderBy(OrderByModel orderByModel) {
        return new OrderByRenderer().render(orderByModel);
    }

    private Optional<FragmentAndParameters> renderPagingModel() {
        return this.multiSelectModel.pagingModel().map(this::renderPagingModel);
    }

    private FragmentAndParameters renderPagingModel(PagingModel pagingModel) {
        return new PagingModelRenderer.Builder().withPagingModel(pagingModel).withRenderingStrategy(this.renderingStrategy).withSequence(this.sequence).build().render();
    }

    public static class Builder {
        private RenderingStrategy renderingStrategy;
        private MultiSelectModel multiSelectModel;

        public Builder withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public Builder withMultiSelectModel(MultiSelectModel multiSelectModel) {
            this.multiSelectModel = multiSelectModel;
            return this;
        }

        public MultiSelectRenderer build() {
            return new MultiSelectRenderer(this);
        }
    }
}

