/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.common.OrderByModel;
import org.mybatis.dynamic.sql.exception.InvalidSqlException;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.select.PagingModel;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.UnionQuery;
import org.mybatis.dynamic.sql.select.render.MultiSelectRenderer;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.Messages;

public class MultiSelectModel {
    private final SelectModel initialSelect;
    private final List<UnionQuery> unionQueries;
    private final OrderByModel orderByModel;
    private final PagingModel pagingModel;

    private MultiSelectModel(Builder builder) {
        this.initialSelect = Objects.requireNonNull(builder.initialSelect);
        this.unionQueries = builder.unionQueries;
        this.orderByModel = builder.orderByModel;
        this.pagingModel = builder.pagingModel;
        if (this.unionQueries.isEmpty()) {
            throw new InvalidSqlException(Messages.getString("ERROR.35"));
        }
    }

    public SelectModel initialSelect() {
        return this.initialSelect;
    }

    public <R> Stream<R> mapUnionQueries(Function<UnionQuery, R> mapper) {
        return this.unionQueries.stream().map(mapper);
    }

    public Optional<OrderByModel> orderByModel() {
        return Optional.ofNullable(this.orderByModel);
    }

    public Optional<PagingModel> pagingModel() {
        return Optional.ofNullable(this.pagingModel);
    }

    @NotNull
    public SelectStatementProvider render(RenderingStrategy renderingStrategy) {
        return new MultiSelectRenderer.Builder().withMultiSelectModel(this).withRenderingStrategy(renderingStrategy).build().render();
    }

    public static class Builder {
        private SelectModel initialSelect;
        private final List<UnionQuery> unionQueries = new ArrayList<UnionQuery>();
        private OrderByModel orderByModel;
        private PagingModel pagingModel;

        public Builder withInitialSelect(SelectModel initialSelect) {
            this.initialSelect = initialSelect;
            return this;
        }

        public Builder withUnionQueries(List<UnionQuery> unionQueries) {
            this.unionQueries.addAll(unionQueries);
            return this;
        }

        public Builder withOrderByModel(OrderByModel orderByModel) {
            this.orderByModel = orderByModel;
            return this;
        }

        public Builder withPagingModel(PagingModel pagingModel) {
            this.pagingModel = pagingModel;
            return this;
        }

        public MultiSelectModel build() {
            return new MultiSelectModel(this);
        }
    }
}

