/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql;

import java.sql.JDBCType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.ParameterTypeConverter;
import org.mybatis.dynamic.sql.SortSpecification;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class SqlColumn<T>
implements BindableColumn<T>,
SortSpecification {
    protected final String name;
    protected final SqlTable table;
    protected final JDBCType jdbcType;
    protected final boolean isDescending;
    protected final String alias;
    protected final String typeHandler;
    protected final RenderingStrategy renderingStrategy;
    protected final ParameterTypeConverter<T, ?> parameterTypeConverter;
    protected final BiFunction<TableAliasCalculator, SqlTable, Optional<String>> tableQualifierFunction;
    protected final Class<T> javaType;

    private SqlColumn(Builder<T> builder) {
        this.name = Objects.requireNonNull(builder.name);
        this.table = Objects.requireNonNull(builder.table);
        this.jdbcType = builder.jdbcType;
        this.isDescending = builder.isDescending;
        this.alias = builder.alias;
        this.typeHandler = builder.typeHandler;
        this.renderingStrategy = builder.renderingStrategy;
        this.parameterTypeConverter = builder.parameterTypeConverter;
        this.tableQualifierFunction = Objects.requireNonNull(builder.tableQualifierFunction);
        this.javaType = builder.javaType;
    }

    public String name() {
        return this.name;
    }

    public SqlTable table() {
        return this.table;
    }

    @Override
    public Optional<JDBCType> jdbcType() {
        return Optional.ofNullable(this.jdbcType);
    }

    @Override
    public Optional<String> alias() {
        return Optional.ofNullable(this.alias);
    }

    @Override
    public Optional<String> typeHandler() {
        return Optional.ofNullable(this.typeHandler);
    }

    @Override
    public Optional<Class<T>> javaType() {
        return Optional.ofNullable(this.javaType);
    }

    @Override
    public Object convertParameterType(T value) {
        return this.parameterTypeConverter == null ? value : this.parameterTypeConverter.convert(value);
    }

    @Override
    public SortSpecification descending() {
        Builder b = this.copy();
        return b.withDescending(true).build();
    }

    @Override
    public SqlColumn<T> as(String alias) {
        Builder b = this.copy();
        return b.withAlias(alias).build();
    }

    public SqlColumn<T> qualifiedWith(String tableQualifier) {
        Builder b = this.copy();
        b.withTableQualifierFunction((tac, t) -> Optional.of(tableQualifier));
        return b.build();
    }

    public SqlColumn<T> asCamelCase() {
        Builder b = this.copy();
        return b.withAlias("\"" + StringUtilities.toCamelCase(this.name) + "\"").build();
    }

    @Override
    public boolean isDescending() {
        return this.isDescending;
    }

    @Override
    public String orderByName() {
        return this.alias().orElse(this.name);
    }

    @Override
    public String renderWithTableAlias(TableAliasCalculator tableAliasCalculator) {
        return this.tableQualifierFunction.apply(tableAliasCalculator, this.table).map(this::applyTableAlias).orElseGet(this::name);
    }

    @Override
    public Optional<RenderingStrategy> renderingStrategy() {
        return Optional.ofNullable(this.renderingStrategy);
    }

    @NotNull
    public <S> SqlColumn<S> withTypeHandler(String typeHandler) {
        Builder<S> b = this.copy();
        return b.withTypeHandler(typeHandler).build();
    }

    @NotNull
    public <S> SqlColumn<S> withRenderingStrategy(RenderingStrategy renderingStrategy) {
        Builder<S> b = this.copy();
        return b.withRenderingStrategy(renderingStrategy).build();
    }

    @NotNull
    public <S> SqlColumn<S> withParameterTypeConverter(ParameterTypeConverter<S, ?> parameterTypeConverter) {
        Builder<S> b = this.copy();
        return b.withParameterTypeConverter(parameterTypeConverter).build();
    }

    @NotNull
    public <S> SqlColumn<S> withJavaType(Class<S> javaType) {
        Builder<S> b = this.copy();
        return b.withJavaType(javaType).build();
    }

    private <S> Builder<S> copy() {
        return new Builder().withName(this.name).withTable(this.table).withJdbcType(this.jdbcType).withDescending(this.isDescending).withAlias(this.alias).withTypeHandler(this.typeHandler).withRenderingStrategy(this.renderingStrategy).withParameterTypeConverter(this.parameterTypeConverter).withTableQualifierFunction(this.tableQualifierFunction).withJavaType(this.javaType);
    }

    private String applyTableAlias(String tableAlias) {
        return tableAlias + "." + this.name();
    }

    public static <T> SqlColumn<T> of(String name, SqlTable table) {
        return new Builder().withName(name).withTable(table).build();
    }

    public static <T> SqlColumn<T> of(String name, SqlTable table, JDBCType jdbcType) {
        return new Builder().withName(name).withTable(table).withJdbcType(jdbcType).build();
    }

    public static class Builder<T> {
        protected String name;
        protected SqlTable table;
        protected JDBCType jdbcType;
        protected boolean isDescending = false;
        protected String alias;
        protected String typeHandler;
        protected RenderingStrategy renderingStrategy;
        protected ParameterTypeConverter<T, ?> parameterTypeConverter;
        protected BiFunction<TableAliasCalculator, SqlTable, Optional<String>> tableQualifierFunction = TableAliasCalculator::aliasForColumn;
        protected Class<T> javaType;

        public Builder<T> withName(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> withTable(SqlTable table) {
            this.table = table;
            return this;
        }

        public Builder<T> withJdbcType(JDBCType jdbcType) {
            this.jdbcType = jdbcType;
            return this;
        }

        public Builder<T> withDescending(boolean isDescending) {
            this.isDescending = isDescending;
            return this;
        }

        public Builder<T> withAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder<T> withTypeHandler(String typeHandler) {
            this.typeHandler = typeHandler;
            return this;
        }

        public Builder<T> withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public Builder<T> withParameterTypeConverter(ParameterTypeConverter<T, ?> parameterTypeConverter) {
            this.parameterTypeConverter = parameterTypeConverter;
            return this;
        }

        private Builder<T> withTableQualifierFunction(BiFunction<TableAliasCalculator, SqlTable, Optional<String>> tableQualifierFunction) {
            this.tableQualifierFunction = tableQualifierFunction;
            return this;
        }

        public Builder<T> withJavaType(Class<T> javaType) {
            this.javaType = javaType;
            return this;
        }

        public SqlColumn<T> build() {
            return new SqlColumn(this);
        }
    }
}

