/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql;

import java.sql.JDBCType;
import java.util.Objects;
import java.util.Optional;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;

public class DerivedColumn<T>
implements BindableColumn<T> {
    private final String name;
    private final String tableQualifier;
    private final String columnAlias;
    private final JDBCType jdbcType;
    private final String typeHandler;

    protected DerivedColumn(Builder<T> builder) {
        this.name = Objects.requireNonNull(((Builder)builder).name);
        this.tableQualifier = ((Builder)builder).tableQualifier;
        this.columnAlias = ((Builder)builder).columnAlias;
        this.jdbcType = ((Builder)builder).jdbcType;
        this.typeHandler = ((Builder)builder).typeHandler;
    }

    @Override
    public Optional<String> alias() {
        return Optional.ofNullable(this.columnAlias);
    }

    @Override
    public Optional<JDBCType> jdbcType() {
        return Optional.ofNullable(this.jdbcType);
    }

    @Override
    public Optional<String> typeHandler() {
        return Optional.ofNullable(this.typeHandler);
    }

    @Override
    public String renderWithTableAlias(TableAliasCalculator tableAliasCalculator) {
        return this.tableQualifier == null ? this.name : this.tableQualifier + "." + this.name;
    }

    @Override
    public DerivedColumn<T> as(String columnAlias) {
        return new Builder().withName(this.name).withColumnAlias(columnAlias).withJdbcType(this.jdbcType).withTypeHandler(this.typeHandler).withTableQualifier(this.tableQualifier).build();
    }

    public static <T> DerivedColumn<T> of(String name) {
        return new Builder().withName(name).build();
    }

    public static <T> DerivedColumn<T> of(String name, String tableQualifier) {
        return new Builder().withName(name).withTableQualifier(tableQualifier).build();
    }

    public static class Builder<T> {
        private String name;
        private String tableQualifier;
        private String columnAlias;
        private JDBCType jdbcType;
        private String typeHandler;

        public Builder<T> withName(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> withTableQualifier(String tableQualifier) {
            this.tableQualifier = tableQualifier;
            return this;
        }

        public Builder<T> withColumnAlias(String columnAlias) {
            this.columnAlias = columnAlias;
            return this;
        }

        public Builder<T> withJdbcType(JDBCType jdbcType) {
            this.jdbcType = jdbcType;
            return this;
        }

        public Builder<T> withTypeHandler(String typeHandler) {
            this.typeHandler = typeHandler;
            return this;
        }

        public DerivedColumn<T> build() {
            return new DerivedColumn(this);
        }
    }
}

