/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage;

import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.cube.cuboid.NLookupCandidate;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StorageContext.class);
    private final int ctxId;
    private Set<TblColRef> dimensions;
    private Set<FunctionDesc> metrics;
    private NLayoutCandidate batchCandidate = NLayoutCandidate.ofEmptyCandidate();
    private NLayoutCandidate streamCandidate = NLayoutCandidate.ofEmptyCandidate();
    private NLookupCandidate lookupCandidate;
    private boolean isDataSkipped;
    private Map<String, List<Long>> prunedPartitions;
    private boolean isPartialMatch = false;
    private boolean isFilterCondAlwaysFalse;

    public StorageContext(int ctxId) {
        this.ctxId = ctxId;
    }

    public NLookupCandidate getLookupCandidate() {
        if (this.streamCandidate.isEmpty() && this.batchCandidate.isEmpty()) {
            return this.lookupCandidate;
        }
        return null;
    }

    public NLayoutCandidate getCandidate() {
        if (this.isBatchCandidateEmpty() && !this.isStreamCandidateEmpty()) {
            return this.streamCandidate;
        }
        return this.batchCandidate;
    }

    public boolean isBatchCandidateEmpty() {
        return this.batchCandidate.getLayoutId() == -1L;
    }

    public boolean isStreamCandidateEmpty() {
        return this.streamCandidate.getLayoutId() == -1L;
    }

    @Generated
    public void setDimensions(Set<TblColRef> dimensions) {
        this.dimensions = dimensions;
    }

    @Generated
    public void setMetrics(Set<FunctionDesc> metrics) {
        this.metrics = metrics;
    }

    @Generated
    public void setBatchCandidate(NLayoutCandidate batchCandidate) {
        this.batchCandidate = batchCandidate;
    }

    @Generated
    public void setStreamCandidate(NLayoutCandidate streamCandidate) {
        this.streamCandidate = streamCandidate;
    }

    @Generated
    public void setLookupCandidate(NLookupCandidate lookupCandidate) {
        this.lookupCandidate = lookupCandidate;
    }

    @Generated
    public void setDataSkipped(boolean isDataSkipped) {
        this.isDataSkipped = isDataSkipped;
    }

    @Generated
    public void setPrunedPartitions(Map<String, List<Long>> prunedPartitions) {
        this.prunedPartitions = prunedPartitions;
    }

    @Generated
    public void setPartialMatch(boolean isPartialMatch) {
        this.isPartialMatch = isPartialMatch;
    }

    @Generated
    public void setFilterCondAlwaysFalse(boolean isFilterCondAlwaysFalse) {
        this.isFilterCondAlwaysFalse = isFilterCondAlwaysFalse;
    }

    @Generated
    public int getCtxId() {
        return this.ctxId;
    }

    @Generated
    public Set<TblColRef> getDimensions() {
        return this.dimensions;
    }

    @Generated
    public Set<FunctionDesc> getMetrics() {
        return this.metrics;
    }

    @Generated
    public NLayoutCandidate getBatchCandidate() {
        return this.batchCandidate;
    }

    @Generated
    public NLayoutCandidate getStreamCandidate() {
        return this.streamCandidate;
    }

    @Generated
    public boolean isDataSkipped() {
        return this.isDataSkipped;
    }

    @Generated
    public Map<String, List<Long>> getPrunedPartitions() {
        return this.prunedPartitions;
    }

    @Generated
    public boolean isPartialMatch() {
        return this.isPartialMatch;
    }

    @Generated
    public boolean isFilterCondAlwaysFalse() {
        return this.isFilterCondAlwaysFalse;
    }
}

