/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.hive;

import java.util.ArrayList;
import java.util.Locale;
import java.util.UUID;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCmdBuilder {
    public static final Logger logger = LoggerFactory.getLogger(HiveCmdBuilder.class);
    static final String CREATE_HQL_TMP_FILE_TEMPLATE = "cat >%s<<EOL\n%sEOL";
    private final ArrayList<String> statements = Lists.newArrayList();
    private KylinConfig kylinConfig;

    public HiveCmdBuilder(KylinConfig kylinConfig) {
        this.kylinConfig = kylinConfig;
        if (null == this.kylinConfig) {
            logger.warn("KylinConfig can not be null, will try KylinConfig.getInstanceFromEnv().");
            this.kylinConfig = KylinConfig.getInstanceFromEnv();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String build() {
        String beelineParams = StringHelper.escapeShellArguments((String)this.kylinConfig.getHiveBeelineParams());
        StringBuilder buf = new StringBuilder();
        String tmpBeelineHqlPath = null;
        StringBuilder beelineHql = new StringBuilder();
        try {
            tmpBeelineHqlPath = "/tmp/" + UUID.randomUUID().toString() + ".hql";
            for (String statement : this.statements) {
                beelineHql.append(statement.replace("`", "\\`"));
                beelineHql.append("\n");
            }
            String createFileCmd = String.format(Locale.ROOT, CREATE_HQL_TMP_FILE_TEMPLATE, tmpBeelineHqlPath, beelineHql);
            buf.append(createFileCmd);
            buf.append("\n");
            buf.append("beeline");
            buf.append(" ");
            buf.append(beelineParams);
            buf.append(" -f ");
            buf.append(tmpBeelineHqlPath);
            buf.append(";ret_code=$?;rm -f ");
            buf.append(tmpBeelineHqlPath);
            buf.append(";exit $ret_code");
        }
        finally {
            if (tmpBeelineHqlPath != null) {
                logger.debug("The SQL to execute in beeline: \n {}", (Object)beelineHql);
            }
        }
        return buf.toString();
    }

    public void addStatement(String statement) {
        this.statements.add(statement);
    }

    public String toString() {
        return this.build();
    }
}

