/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.Model;
import springfox.documentation.schema.ModelSpecification;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.ApiListing;
import springfox.documentation.service.ModelNamesRegistry;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.Tag;
import springfox.documentation.service.Tags;

public class ApiListingBuilder {
    private final Comparator<ApiDescription> descriptionOrdering;
    private String apiVersion;
    private String basePath;
    private String resourcePath;
    private String description;
    private String host;
    private int position;
    private Set<String> produces = new TreeSet<String>();
    private Set<String> consumes = new TreeSet<String>();
    private final Set<String> protocol = new TreeSet<String>();
    private List<SecurityReference> securityReferences = new ArrayList<SecurityReference>();
    private List<ApiDescription> apis = new ArrayList<ApiDescription>();
    private final Set<Tag> tags = new TreeSet<Tag>(Tags.tagComparator());
    private final Set<String> tagNames = new TreeSet<String>();
    private final Map<String, Model> models = new TreeMap<String, Model>();
    private final Map<String, Tag> tagLookup = new TreeMap<String, Tag>();
    private final Map<String, ModelSpecification> modelSpecifications = new TreeMap<String, ModelSpecification>();
    private ModelNamesRegistry modelNamesRegistry;

    public ApiListingBuilder(Comparator<ApiDescription> descriptionOrdering) {
        this.descriptionOrdering = descriptionOrdering;
    }

    public ApiListingBuilder apiVersion(String apiVersion) {
        this.apiVersion = BuilderDefaults.defaultIfAbsent(apiVersion, this.apiVersion);
        return this;
    }

    public ApiListingBuilder basePath(String basePath) {
        this.basePath = BuilderDefaults.defaultIfAbsent(basePath, this.basePath);
        return this;
    }

    public ApiListingBuilder resourcePath(String resourcePath) {
        this.resourcePath = BuilderDefaults.defaultIfAbsent(resourcePath, this.resourcePath);
        return this;
    }

    public ApiListingBuilder produces(Set<String> mediaTypes) {
        if (mediaTypes != null) {
            this.produces = new HashSet<String>(mediaTypes);
        }
        return this;
    }

    public ApiListingBuilder consumes(Set<String> mediaTypes) {
        if (mediaTypes != null) {
            this.consumes = new HashSet<String>(mediaTypes);
        }
        return this;
    }

    public ApiListingBuilder appendProduces(List<String> produces) {
        this.produces.addAll(BuilderDefaults.nullToEmptyList(produces).stream().filter(Objects::nonNull).collect(Collectors.toSet()));
        return this;
    }

    public ApiListingBuilder appendConsumes(List<String> consumes) {
        this.consumes.addAll(BuilderDefaults.nullToEmptyList(consumes).stream().filter(Objects::nonNull).collect(Collectors.toSet()));
        return this;
    }

    public ApiListingBuilder host(String host) {
        this.host = BuilderDefaults.defaultIfAbsent(host, this.host);
        return this;
    }

    public ApiListingBuilder protocols(Set<String> protocols) {
        this.protocol.addAll(BuilderDefaults.nullToEmptySet(protocols));
        return this;
    }

    public ApiListingBuilder securityReferences(List<SecurityReference> securityReferences) {
        if (securityReferences != null) {
            this.securityReferences = new ArrayList<SecurityReference>(securityReferences);
        }
        return this;
    }

    public ApiListingBuilder apis(List<ApiDescription> apis) {
        if (apis != null) {
            this.apis = apis.stream().sorted(this.descriptionOrdering).collect(Collectors.toList());
        }
        return this;
    }

    public ApiListingBuilder models(Map<String, Model> models) {
        this.models.putAll(BuilderDefaults.nullToEmptyMap(models));
        return this;
    }

    public ApiListingBuilder modelSpecifications(Map<String, ModelSpecification> models) {
        this.modelSpecifications.putAll(BuilderDefaults.nullToEmptyMap(models));
        return this;
    }

    public ApiListingBuilder description(String description) {
        this.description = BuilderDefaults.defaultIfAbsent(description, this.description);
        return this;
    }

    public ApiListingBuilder position(int position) {
        this.position = position;
        return this;
    }

    public ApiListingBuilder tagNames(Set<String> tagNames) {
        this.tagNames.addAll(BuilderDefaults.nullToEmptySet(tagNames).stream().filter(Objects::nonNull).collect(Collectors.toSet()));
        return this;
    }

    public ApiListingBuilder tags(Set<Tag> tags) {
        this.tags.addAll(BuilderDefaults.nullToEmptySet(tags));
        return this;
    }

    public ApiListingBuilder availableTags(Set<Tag> availableTags) {
        this.tagLookup.putAll(BuilderDefaults.nullToEmptySet(availableTags).stream().collect(Collectors.toMap(Tag::getName, Function.identity())));
        return this;
    }

    public ApiListingBuilder modelNamesRegistry(ModelNamesRegistry modelNamesRegistry) {
        this.modelNamesRegistry = modelNamesRegistry;
        return this;
    }

    public ApiListing build() {
        this.tags.addAll(this.tagNames.stream().filter(Tags.emptyTags()).map(Tags.toTag(Tags.descriptor(this.tagLookup, this.description))).collect(Collectors.toSet()));
        return new ApiListing(this.apiVersion, this.basePath, this.resourcePath, this.produces, this.consumes, this.host, this.protocol, this.securityReferences, this.apis, this.models, this.modelSpecifications, this.modelNamesRegistry, this.description, this.position, this.tags);
    }
}

