/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.sql.type.SqlTypeAssignmentRule;
import org.apache.calcite.sql.type.SqlTypeCoercionRule;
import org.apache.calcite.sql.type.SqlTypeMappingRule;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;
import org.apache.kylin.guava30.shaded.common.cache.CacheBuilder;
import org.apache.kylin.guava30.shaded.common.cache.CacheLoader;
import org.apache.kylin.guava30.shaded.common.cache.LoadingCache;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.guava30.shaded.common.util.concurrent.UncheckedExecutionException;

public abstract class SqlTypeMappingRules {
    public static SqlTypeMappingRule instance(boolean coerce) {
        if (coerce) {
            return SqlTypeCoercionRule.instance();
        }
        return SqlTypeAssignmentRule.instance();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        final Map<SqlTypeName, ImmutableSet<SqlTypeName>> map = new HashMap<SqlTypeName, ImmutableSet<SqlTypeName>>();
        final LoadingCache<Set<SqlTypeName>, ImmutableSet<SqlTypeName>> sets = CacheBuilder.newBuilder().build(CacheLoader.from(set -> Sets.immutableEnumSet((Iterable)set)));

        Builder() {
        }

        void add(SqlTypeName fromType, Set<SqlTypeName> toTypes) {
            try {
                this.map.put(fromType, (ImmutableSet<SqlTypeName>)this.sets.get(toTypes));
            }
            catch (ExecutionException | UncheckedExecutionException e) {
                throw Util.throwAsRuntime("populating SqlTypeAssignmentRules", Util.causeOrSelf(e));
            }
        }

        void addAll(Map<SqlTypeName, ImmutableSet<SqlTypeName>> typeMapping) {
            try {
                this.map.putAll(typeMapping);
            }
            catch (UncheckedExecutionException e) {
                throw Util.throwAsRuntime("populating SqlTypeAssignmentRules", Util.causeOrSelf(e));
            }
        }

        ImmutableSet.Builder<SqlTypeName> copyValues(SqlTypeName typeName) {
            return ImmutableSet.builder().addAll((Iterable)Nullness.castNonNull(this.map.get((Object)typeName)));
        }
    }
}

