/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.logical;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;

public final class LogicalCorrelate
extends Correlate {
    public LogicalCorrelate(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType joinType) {
        super(cluster, traitSet, hints, left, right, correlationId, requiredColumns, joinType);
    }

    @Deprecated
    public LogicalCorrelate(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType joinType) {
        this(cluster, traitSet, (List<RelHint>)ImmutableList.of(), left, right, correlationId, requiredColumns, joinType);
    }

    public LogicalCorrelate(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), (List<RelHint>)ImmutableList.of(), input.getInputs().get(0), input.getInputs().get(1), new CorrelationId((Integer)Objects.requireNonNull(input.get("correlation"), "correlation")), input.getBitSet("requiredColumns"), Objects.requireNonNull(input.getEnum("joinType", JoinRelType.class), "joinType"));
    }

    public static LogicalCorrelate create(RelNode left, RelNode right, List<RelHint> hints, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType joinType) {
        RelOptCluster cluster = left.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)Convention.NONE);
        return new LogicalCorrelate(cluster, traitSet, hints, left, right, correlationId, requiredColumns, joinType);
    }

    @Deprecated
    public static LogicalCorrelate create(RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType joinType) {
        return LogicalCorrelate.create(left, right, (List<RelHint>)ImmutableList.of(), correlationId, requiredColumns, joinType);
    }

    @Override
    public LogicalCorrelate copy(RelTraitSet traitSet, RelNode left, RelNode right, CorrelationId correlationId, ImmutableBitSet requiredColumns, JoinRelType joinType) {
        assert (traitSet.containsIfApplicable(Convention.NONE));
        return new LogicalCorrelate(this.getCluster(), traitSet, (List<RelHint>)this.hints, left, right, correlationId, requiredColumns, joinType);
    }

    @Override
    public RelNode accept(RelShuttle shuttle) {
        return shuttle.visit(this);
    }

    @Override
    public RelNode withHints(List<RelHint> hintList) {
        return new LogicalCorrelate(this.getCluster(), this.traitSet, hintList, this.left, this.right, this.correlationId, this.requiredColumns, this.joinType);
    }
}

